/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.render;

import com.jdolphin.ricksportalgun.client.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.client.render.state.PortalEntityRenderState;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class PortalEntityRenderer
extends EntityRenderer<PortalEntity, PortalEntityRenderState> {
    public static final ResourceLocation PORTAL_TEXTURE = PGHelper.id("textures/entity/portal.png");
    public PortalEntityModel model;
    private static int textureFrame = 0;
    private static final int frames = 8;
    private final List<String> names = List.of(new String[]{"_jeb", "rainbow", "rgb", "colourful", "colorful"});
    private static int tickTimer = 0;

    public PortalEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.bakeLayer(PortalEntityModel.LAYER_LOCATION));
    }

    @NotNull
    public PortalEntityRenderState createRenderState() {
        return new PortalEntityRenderState();
    }

    public ResourceLocation getPortalTexture(int i) {
        return PGHelper.id("textures/entity/portal_" + i + ".png");
    }

    public void extractRenderState(PortalEntity portal, PortalEntityRenderState state, float pPartialTick) {
        super.extractRenderState((Entity)portal, (EntityRenderState)state, pPartialTick);
        state.rgb = portal.getColor();
        state.yRot = portal.getYRot();
        state.isNew = !portal.exists();
        state.closing = (double)portal.tickCount > (double)portal.getLifetime() * 0.9;
        state.opening = (double)portal.tickCount < (double)portal.getLifetime() * 0.1;
        state.direction = portal.getPortalDirection();
        state.facing = portal.getPortalFacing();
        state.width = portal.getSize();
        state.name = portal.getName();
    }

    protected void openAnimation(PortalEntityRenderState state, PoseStack stack) {
        float f;
        if (state.isNew && state.opening) {
            f = Mth.lerp((float)(state.ageInTicks / 20.0f), (float)0.0f, (float)1.0f);
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.scale(f, f, f);
        }
        if (state.closing) {
            f = Mth.lerp((float)(state.ageInTicks / 20.0f), (float)1.0f, (float)0.0f);
            f = Mth.clamp((float)f, (float)1.0f, (float)0.0f);
            f *= f;
            f *= f;
            stack.scale(f, f, f);
        }
    }

    public void render(@NotNull PortalEntityRenderState state, PoseStack stack, MultiBufferSource source, int pPackedLight) {
        stack.pushPose();
        this.openAnimation(state, stack);
        Direction direction = state.direction;
        Direction facing = state.facing;
        stack.translate(0.0f, -1.0f, 0.0f);
        if (direction != null) {
            float height;
            Direction.Axis axis = facing.getAxis();
            float zRot = 0.0f;
            float yRot = 0.0f;
            float xRot = 0.0f;
            float f = height = state.width > 2.0f ? state.width / 2.0f : 1.0f;
            if (direction.getAxis().isVertical()) {
                if (axis.equals((Object)Direction.Axis.Z)) {
                    stack.scale(state.width, 1.0f, height);
                    zRot = 180.0f;
                    yRot = 180.0f;
                    xRot = 90.0f;
                    stack.translate(0.0, 1.1, -1.0);
                }
                if (axis.equals((Object)Direction.Axis.X)) {
                    stack.scale(height, 1.0f, state.width);
                    xRot = 0.0f;
                    yRot = 270.0f;
                    zRot = 90.0f;
                    stack.translate(-1.0, 1.1, 0.0);
                }
            } else {
                stack.scale(state.width, height, state.width);
            }
            stack.mulPose(Axis.XN.rotationDegrees(xRot));
            stack.mulPose(Axis.ZN.rotationDegrees(zRot));
            stack.mulPose(Axis.YN.rotationDegrees(direction.getAxis().isVertical() ? yRot : state.yRot));
        }
        VertexConsumer consumer = source.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getPortalTexture(textureFrame)));
        int i = state.rgb;
        if (state.name != null && this.names.contains(state.name.getString().toLowerCase())) {
            int k = Mth.floor((float)state.ageInTicks);
            int l = k / 25;
            int i1 = DyeColor.values().length;
            int j1 = l % i1;
            int k1 = (l + 1) % i1;
            float f = ((float)(k % 25) + Mth.frac((float)state.ageInTicks)) / 25.0f;
            int l1 = Sheep.getColor((DyeColor)DyeColor.byId((int)j1));
            int i2 = Sheep.getColor((DyeColor)DyeColor.byId((int)k1));
            i = ARGB.lerp((float)f, (int)l1, (int)i2);
        }
        this.model.renderToBuffer(stack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, i);
        stack.popPose();
        super.render((EntityRenderState)state, stack, source, pPackedLight);
    }

    public static void tickTexture() {
        if (++tickTimer >= 4) {
            tickTimer = 0;
            textureFrame = (textureFrame + 1) % 8;
        }
    }
}

