/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen;

import com.jdolphin.ricksportalgun.client.screen.widget.PGScrollableWidget;
import com.jdolphin.ricksportalgun.client.screen.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.menu.PortalDispenserMenu;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetDispenserDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class PortalDispenserScreen
extends AbstractContainerScreen<PortalDispenserMenu> {
    public static final ResourceLocation CONTAINER_LOCATION = PGHelper.id("textures/gui/dispenser/portal_dispenser.png");
    private EditBox xInput;
    private EditBox yInput;
    private EditBox zInput;
    private Button selectButton;
    private SuggestionTextFieldWidget dimInput;
    private final List<String> dimSuggestions = LevelHelper.CLIENT_DIMENSIONS;

    public PortalDispenserScreen(PortalDispenserMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.dimInput.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void onEdited(String string) {
        this.dimInput.setSuggestion("");
        this.dimInput.update();
        this.xInput.setTextColor(0xFFFFFF);
        this.yInput.setTextColor(0xFFFFFF);
        this.zInput.setTextColor(0xFFFFFF);
        this.dimInput.setTextColor(0xFFFFFF);
    }

    public boolean mouseScrolled(double d, double d1, double d2, double d3) {
        Object t;
        Optional optional = this.getChildAt(d, d1);
        if (optional.isPresent() && (t = optional.get()) instanceof PGScrollableWidget) {
            PGScrollableWidget list = (PGScrollableWidget)((Object)t);
            return list.mouseScrolled(d, d1, d2, d3);
        }
        return super.mouseScrolled(d, d1, d2, d3);
    }

    protected void init() {
        super.init();
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.xInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 - 64, 32, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.yInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 8, this.height / 2 - 64, 32, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.zInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 48, this.height / 2 - 64, 32, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.dimInput = new SuggestionTextFieldWidget(this.width / 2 - 32, this.height / 2 - 48, 112, 12, Component.translatable((String)"chat.editBox"), this.dimSuggestions);
        this.dimInput.update();
        this.setupSuggestionBox(this.dimInput);
        this.addWidget((GuiEventListener)this.dimInput.getSuggestionList());
        this.selectButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            try {
                int x = Integer.parseInt(this.xInput.getValue());
                int y = Integer.parseInt(this.yInput.getValue());
                int z = Integer.parseInt(this.zInput.getValue());
                String dim = this.dimInput.getValue();
                BlockPos pos = new BlockPos(x, y, z);
                SBSetDispenserDestinationPacket packet = new SBSetDispenserDestinationPacket(pos, dim);
                PGHelper.sendPacketToServer(packet);
            }
            catch (Exception e) {
                this.dimInput.setSuggestion(" \u00a7c" + e.getLocalizedMessage());
            }
            this.onClose();
        }).pos(this.width / 2 - 32, this.height / 2 - 32).size(112, 16).build());
    }

    private void setupSuggestionBox(EditBox box) {
        box.setCanLoseFocus(true);
        box.setTextColor(-1);
        box.setTextColorUneditable(-1);
        box.setBordered(true);
        box.setMaxLength(50);
        box.setValue("");
        box.setResponder(this::onEdited);
        this.addWidget((GuiEventListener)box);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.dimInput.keyPressed(keyCode, scanCode, modifiers) || this.dimInput.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.dimInput.render(graphics, mouseX, mouseY, delta);
        this.xInput.render(graphics, mouseX, mouseY, delta);
        this.yInput.render(graphics, mouseX, mouseY, delta);
        this.zInput.render(graphics, mouseX, mouseY, delta);
        if (!this.dimInput.isFocused()) {
            this.selectButton.render(graphics, mouseX, mouseY, delta);
        }
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int maxFuel = Math.max(((PortalDispenserMenu)this.menu).getMaxFuel(), 1);
        int percentage = 52 * ((PortalDispenserMenu)this.menu).getFuel() / maxFuel;
        int minX = x + 8;
        int minY = y + 68;
        int maxX = x + 23;
        graphics.fill(minX, minY, maxX, minY - percentage, Color.GREEN.getRGB());
        if (mouseX >= minX && mouseX <= maxX && mouseY >= minY - 4 * maxFuel + 12 && mouseY <= minY) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.portal_dispenser.fuel", (Object[])new Object[]{((PortalDispenserMenu)this.menu).getFuel(), maxFuel}), mouseX, mouseY);
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float v, int i, int i1) {
        int i2 = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderType::guiTextured, CONTAINER_LOCATION, i2, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }
}

