/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetBarrierCodePacket;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class SubetherBarrierScreen
extends AbstractBaseScreen {
    private EditBox codeBox;
    private BlockPos pos;

    public SubetherBarrierScreen(BlockPos pos) {
        super("menu.ricksportalgun.sub_ether_barrier");
        this.pos = pos;
    }

    public void init() {
        super.init();
        this.codeBox = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 64, this.height / 2 - 40, 128, 20, (Component)Component.translatable((String)"chat.editBox")));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            this.setCode();
            this.onClose();
        }).pos(this.width / 2 - 128, this.height / 2 + 32).size(128, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose()).size(128, 20).pos(this.width / 2 + 8, this.height / 2 + 32).build());
    }

    public void render(@NotNull GuiGraphics stack, int pMouseX, int pMouseY, float pPartialTick) {
        GuiHelper.drawWhiteCenteredString(stack, (Component)Component.translatable((String)"menu.ricksportalgun.sub_ether_barrier"), this.width / 2, 30);
        GuiHelper.drawWhiteCenteredString(stack, (Component)Component.translatable((String)"ricksportalgun.barrier_code", (Object[])new Object[]{""}), this.width / 2, this.codeBox.getY() - 16);
        this.codeBox.render(stack, pMouseX, pMouseY, pPartialTick);
        Style style = GuiHelper.getStyle(pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(stack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(stack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                this.setCode();
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    protected void setCode() {
        String code = this.codeBox.getValue();
        SBSetBarrierCodePacket packet = new SBSetBarrierCodePacket(code, this.pos);
        PGHelper.sendPacketToServer(packet);
        this.onClose();
    }
}

