/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBManageWaypointsPacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class WaypointInfoScreen
extends AbstractBaseScreen {
    private final Waypoint wp;
    private PGTextButton select;
    private PGTextButton delete;
    private PGImageButton backButton;

    public WaypointInfoScreen(Waypoint waypoint) {
        super("menu.ricksportalgun.waypoints.info");
        this.wp = waypoint;
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        this.fillBackgroundColor(graphics);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info"), this.width / 2, this.height / 2 - 92, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.name", (Object[])new Object[]{this.wp.getName()}), this.width / 2 - 64, this.height / 2 - 48, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.x", (Object[])new Object[]{this.wp.getX()}), this.width / 2 - 64, this.height / 2 - 32, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.y", (Object[])new Object[]{this.wp.getY()}), this.width / 2 - 64, this.height / 2 - 16, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.z", (Object[])new Object[]{this.wp.getZ()}), this.width / 2 - 64, this.height / 2, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.dimension", (Object[])new Object[]{this.wp.getDimension()}), this.width / 2 - 64, this.height / 2 + 16, style.textColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.delete, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        this.drawOverlay(graphics);
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, pMouseX, pMouseY, pPartialTick);
        }
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null && this.minecraft.player != null);
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            SBSetDestinationPacket packet = new SBSetDestinationPacket(this.wp.getBlockPos(), this.wp.getDimension());
            PGHelper.sendPacketToServer(packet);
            this.onClose();
        }, this.font));
        this.delete = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.delete"), button -> {
            SBManageWaypointsPacket packet = new SBManageWaypointsPacket(this.wp.getWaypointString(), true);
            PGHelper.sendPacketToServer(packet);
            this.minecraft.setScreen((Screen)new WaypointScreen());
        }, this.font));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.new"), button -> this.minecraft.setScreen((Screen)new WaypointScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        PortalGunStyle style = this.getStyle();
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }
}

