/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.SettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.settings.ColourPickingScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.settings.ThemeEditScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGSlider;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBCustomizeSettingsPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CustomizationSettingsScreen
extends AbstractBaseScreen {
    public static ResourceLocation RESET_LOCATION = PGHelper.id("textures/gui/sprites/icon/reset.png");
    private PGSlider portalSize;
    private PGSlider portalAge;
    private PGTextButton portalColor;
    private PGTextButton menuTheme;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGImageButton resetSize;
    private PGImageButton resetAge;
    private PGImageButton backButton;

    public CustomizationSettingsScreen() {
        super("menu.ricksportalgun.settings.customization");
    }

    public void init() {
        super.init();
        assert (this.minecraft != null && this.minecraft.player != null);
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = player.getMainHandItem();
        float size = ((Float)stack.getOrDefault(PGDataComponents.PORTAL_SIZE, (Object)Float.valueOf(1.0f))).floatValue();
        int age = (Integer)stack.getOrDefault(PGDataComponents.PORTAL_LIFETIME, (Object)10);
        this.portalSize = (PGSlider)this.addWidget((GuiEventListener)new PGSlider(this.width / 2 + 62, this.height / 2 - 64, 42, 18, (Component)Component.empty(), size, 1.0, 3.0, true));
        this.resetSize = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.portalSize.getX() + this.portalSize.getWidth() + 10, this.portalSize.getY() - 1, 21, 21, (Component)Component.translatable((String)"ricksportalgun.button.portal_size.reset"), button -> this.portalSize.setValue(1.0), 16, 16, RESET_LOCATION));
        this.portalAge = (PGSlider)this.addWidget((GuiEventListener)new PGSlider(this.width / 2 + 62, this.height / 2 - 40, 42, 18, (Component)Component.empty(), age, 5.0, 45.0, true));
        this.resetAge = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.portalAge.getX() + this.portalAge.getWidth() + 10, this.portalAge.getY() - 1, 21, 21, (Component)Component.translatable((String)"ricksportalgun.button.portal_age.reset"), button -> this.portalAge.setValue(10.0), 16, 16, RESET_LOCATION));
        this.portalColor = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 128, this.height / 2 - 16, 256, 18, (Component)Component.translatable((String)"ricksportalgun.button.settings.customization.color"), button -> this.minecraft.setScreen((Screen)new ColourPickingScreen()), this.font));
        this.menuTheme = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 128, this.height / 2 + 8, 256, 18, (Component)Component.translatable((String)"ricksportalgun.button.settings.customization.theme"), button -> this.minecraft.setScreen((Screen)new ThemeEditScreen()), this.font));
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            SBCustomizeSettingsPacket packet = new SBCustomizeSettingsPacket(this.portalSize.getValue(), this.portalAge.getValueInt());
            PGHelper.sendPacketToServer(packet);
            this.onClose();
        }, this.font));
        this.cancel = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose(), this.font));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.back"), button -> this.minecraft.setScreen((Screen)new SettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        PortalGunStyle style = this.getStyle();
        this.resetAge.setRenderBackground(false);
        this.resetSize.setRenderBackground(false);
        this.resetAge.setColor(style.highlightColor());
        this.resetSize.setColor(style.highlightColor());
        this.select.setTextColour(style.textColor());
        this.cancel.setTextColour(style.textColor());
        this.portalColor.setTextColour(style.textColor());
        this.menuTheme.setTextColour(style.textColor());
        this.portalSize.setRenderBG(false);
        this.portalAge.setRenderBG(false);
        this.portalSize.setStyle(style);
        this.portalAge.setStyle(style);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PortalGunStyle style = this.getStyle();
        this.fillBackgroundColor(graphics);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.settings.customization"), this.width / 2, this.height / 2 - 92, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.portal_size"), this.width / 2 - 128, this.portalSize.getY() + 4, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.portal_age"), this.width / 2 - 128, this.portalAge.getY() + 4, style.textColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.portalColor, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.menuTheme, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.resetSize, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.resetAge, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        GuiHelper.renderWidgets(graphics, mouseX, mouseY, delta, new AbstractWidget[]{this.portalSize, this.portalAge});
        GuiHelper.renderTooltip(graphics, (Component)Component.translatable((String)"ricksportalgun.button.portal_size.reset"), (AbstractWidget)this.resetSize);
        GuiHelper.renderTooltip(graphics, (Component)Component.translatable((String)"ricksportalgun.button.portal_age.reset"), (AbstractWidget)this.resetAge);
        Style guiStyle = GuiHelper.getStyle(mouseX, mouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, mouseX, mouseY, delta);
        }
        this.drawOverlay(graphics);
        super.render(graphics, mouseX, mouseY, delta);
    }
}

