/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.workbench;

import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGItemButton;
import com.jdolphin.ricksportalgun.client.screen.workbench.AbstractWorkbenchScreen;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.init.PortalGunTypeRegistry;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.menu.workbench.SkinSelectorMenu;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetPortalGunTypePacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SkinSelectingScreen
extends AbstractWorkbenchScreen<SkinSelectorMenu> {
    public static final ResourceLocation BG = PGHelper.id("textures/gui/workbench/skin_select.png");
    public static ResourceLocation NEXT = PGHelper.id("textures/gui/sprites/next.png");
    public static ResourceLocation NEXT_HL = PGHelper.id("textures/gui/sprites/next_highlighted.png");
    public static ResourceLocation PREVIOUS = PGHelper.id("textures/gui/sprites/previous.png");
    public static ResourceLocation PREVIOUS_HL = PGHelper.id("textures/gui/sprites/previous_highlighted.png");
    private PGImageButton next;
    private PGImageButton previous;
    private Button select;
    private int index = 0;
    private float rot = 0.0f;
    private double scroll = 0.0;

    public SkinSelectingScreen(SkinSelectorMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 220;
        this.imageHeight = 192;
        this.inventoryLabelX = this.imageWidth - 188;
        this.inventoryLabelY = this.imageHeight - 93;
        this.titleLabelX = this.imageWidth - 193;
        this.titleLabelY = this.imageHeight - 188;
    }

    public void init() {
        super.init();
        this.next = (PGImageButton)this.addWidget((GuiEventListener)new PGImageButton(this.width / 2 + 66, this.height / 2 - 26, 12, 32, (Component)Component.translatable((String)"ricksportalgun.button.next"), button -> this.cycleValue(1), 32, 23, NEXT));
        this.next.setRenderBackground(false);
        this.previous = (PGImageButton)this.addWidget((GuiEventListener)new PGImageButton(this.width / 2 + 8, this.height / 2 - 26, 12, 32, (Component)Component.translatable((String)"ricksportalgun.button.previous"), button -> this.cycleValue(-1), 32, 23, PREVIOUS));
        this.previous.setRenderBackground(false);
        this.select = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            SBSetPortalGunTypePacket packet = new SBSetPortalGunTypePacket(this.getType());
            PGHelper.sendPacketToServer(packet);
        }).bounds(this.width / 2 + 16, this.height / 2 - 18, 48, 16).build());
        PGItemButton skin = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 87, this.height / 2 - 95, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.skin"), button -> {}, PGItems.PORTAL_GUN.getDefaultInstance()));
        skin.setRenderBackground(false);
        PGItemButton waypoint = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 87, this.height / 2 - 70, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.waypoint"), button -> this.setScreen(0), PGItems.DATA_CARD.getDefaultInstance()));
        waypoint.setRenderBackground(false);
        PGItemButton craft = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 87, this.height / 2 - 45, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.craft"), button -> this.setScreen(2), Items.CRAFTING_TABLE.getDefaultInstance()));
        craft.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)skin, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.skin"));
        GuiHelper.setTooltip((AbstractWidget)waypoint, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.waypoint"));
        GuiHelper.setTooltip((AbstractWidget)craft, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.craft"));
    }

    private ItemStack getStack(int slotId) {
        return ((SkinSelectorMenu)this.menu).getSlot(slotId).getItem();
    }

    private PortalGunType getType() {
        ArrayList<PortalGunType> list = PortalGunTypeRegistry.CLIENT_TYPES;
        return (PortalGunType)list.get(this.index);
    }

    private void cycleValue(int delta) {
        ArrayList<PortalGunType> list = PortalGunTypeRegistry.CLIENT_TYPES;
        this.index = Mth.positiveModulo((int)(this.index + delta), (int)list.size());
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        Optional<Object> optional = Optional.empty();
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            if (this.hoveredSlot.index == 36) {
                optional = Optional.of(Component.translatable((String)"notice.ricksportalgun.workbench.insert_portal_gun"));
            } else if (this.hoveredSlot.index == 37 || this.hoveredSlot.index == 38) {
                optional = Optional.of(Component.translatable((String)"notice.ricksportalgun.workbench.insert_dye_or_bucket"));
            }
            optional.ifPresent(component -> guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)component, 115), x, y));
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        ItemStack stack = this.getStack(36);
        if (!stack.isEmpty() && stack.is(PGTags.Items.PORTAL_GUNS)) {
            PortalGunType chooseType = this.getType();
            PortalGunType currentType = PortalGunItem.getPortalGunType(stack);
            graphics.enableScissor(this.width / 2 - 91, this.height / 2 - 84, this.width / 2 - 3, this.height / 2 - 28);
            GuiHelper.drawWordWrap(graphics, this.font, (FormattedText)Component.translatable((String)"ricksportalgun.gun_type", (Object[])new Object[]{""}).append(currentType.name()), this.width / 2 - 48, this.height / 2 - 62, 86, Color.WHITE.getRGB());
            graphics.disableScissor();
            graphics.enableScissor(this.width / 2, this.height / 2 - 84, this.width / 2 + 81, this.height / 2 - 60);
            GuiHelper.drawWordWrap(graphics, this.font, (FormattedText)chooseType.name(), this.width / 2 + 40, this.height / 2 - 82, 82, Color.WHITE.getRGB());
            graphics.disableScissor();
            this.select.render(graphics, mouseX, mouseY, delta);
            this.next.render(graphics, mouseX, mouseY, delta);
            this.previous.render(graphics, mouseX, mouseY, delta);
        }
        this.next.setTexture(this.next.isHovered() ? NEXT_HL : NEXT);
        this.previous.setTexture(this.previous.isHovered() ? PREVIOUS_HL : PREVIOUS);
        this.renderPortalGunType(graphics, mouseX, mouseY, delta);
    }

    private void renderPortalGunType(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PortalGunType type = this.getType();
        ItemStack stack = this.getStack(36);
        if (stack.is(PGTags.Items.PORTAL_GUNS)) {
            DyeItem dyeItem;
            Item item;
            ItemStack fakeStack = stack.copy();
            ItemStack dyeStack1 = this.getStack(37);
            ItemStack dyeStack2 = this.getStack(38);
            int primary = 0;
            int secondary = 0;
            if (!dyeStack1.isEmpty()) {
                item = dyeStack1.getItem();
                if (item instanceof DyeItem) {
                    dyeItem = (DyeItem)item;
                    primary = dyeItem.getDyeColor().getTextureDiffuseColor();
                } else if (dyeStack1.is(Items.WATER_BUCKET)) {
                    fakeStack.remove(PGDataComponents.PRIMARY_DYE);
                }
            }
            if (!dyeStack2.isEmpty()) {
                item = dyeStack2.getItem();
                if (item instanceof DyeItem) {
                    dyeItem = (DyeItem)item;
                    secondary = dyeItem.getDyeColor().getTextureDiffuseColor();
                } else if (dyeStack2.is(Items.WATER_BUCKET)) {
                    fakeStack.remove(PGDataComponents.SECONDARY_DYE);
                }
            }
            int color = PortalGunItem.getColor(stack);
            PortalGunItem.setPortalGunType(fakeStack, type);
            PortalGunItem.setColor(fakeStack, color);
            if (primary != 0) {
                PortalGunItem.setPrimaryDye(fakeStack, primary);
            }
            if (secondary != 0) {
                PortalGunItem.setSecondaryDye(fakeStack, secondary);
            }
            graphics.enableScissor(this.width / 2, this.height / 2 - 62, this.width / 2 + 81, this.height / 2 - 18);
            this.renderFakeItem(graphics, fakeStack, 36.0f, this.width / 2 + 40, this.height / 2 - 44, 32, mouseX, mouseY);
            graphics.disableScissor();
        }
    }

    public void renderFakeItem(GuiGraphics graphics, ItemStack stack, float scale, int x, int y, int z, int mouseX, int mouseY) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, (float)z);
        poseStack.scale(scale, -scale, scale);
        if (SkinSelectingScreen.hasShiftDown()) {
            poseStack.mulPose(Axis.YP.rotationDegrees((float)mouseX));
            poseStack.mulPose(Axis.XN.rotationDegrees((float)mouseY * 2.0f + 180.0f));
            float zoom = (float)(this.scroll / 2.0);
            if (zoom > 0.0f) {
                poseStack.scale(zoom, zoom, zoom);
            }
        } else {
            float f = this.rot;
            this.rot = f + 1.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(f / 3.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
        }
        ItemStackRenderState state = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(state, stack, ItemDisplayContext.FIXED, false, null, null, 0);
        graphics.drawSpecial(source -> state.render(poseStack, source, 0xF000F0, OverlayTexture.NO_OVERLAY));
        poseStack.popPose();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (SkinSelectingScreen.hasShiftDown()) {
            this.scroll += dragY > 0.0 ? Mth.clamp((double)dragY, (double)0.1, (double)2.0) : Mth.clamp((double)dragY, (double)-2.0, (double)-0.1);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderType::guiTextured, BG, x + 12, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }
}

