/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.workbench;

import com.jdolphin.ricksportalgun.client.screen.widget.PGItemButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGScrollableWidget;
import com.jdolphin.ricksportalgun.client.screen.widget.WaypointListWidget;
import com.jdolphin.ricksportalgun.client.screen.workbench.AbstractWorkbenchScreen;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.menu.workbench.WaypointTransferMenu;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBWorkbenchWaypointEditPackage;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import oshi.util.tuples.Pair;

public class WaypointTransferScreen
extends AbstractWorkbenchScreen<WaypointTransferMenu> {
    public static final ResourceLocation BG = PGHelper.id("textures/gui/workbench/waypoint_transfer.png");
    public static final ResourceLocation WP_INFO_BG = PGHelper.id("textures/gui/workbench/waypoint_info_bg.png");
    private WaypointListWidget leftWaypointList;
    private WaypointListWidget rightWaypointList;
    private Pair<Waypoint, Side> selectedWaypoint;
    private Button copy;
    private Button moveTo;
    private Button delete;

    public WaypointTransferScreen(WaypointTransferMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageHeight = 211;
        this.imageWidth = 212;
        this.inventoryLabelX = this.imageWidth - 188;
        this.inventoryLabelY = this.imageHeight - 93;
        this.titleLabelX = this.imageWidth - 193;
        this.titleLabelY = this.imageHeight - 207;
    }

    public boolean mouseScrolled(double d, double d1, double d2, double d3) {
        Object t;
        Optional optional = this.getChildAt(d, d1);
        if (optional.isPresent() && (t = optional.get()) instanceof PGScrollableWidget) {
            PGScrollableWidget list = (PGScrollableWidget)((Object)t);
            return list.mouseScrolled(d, d1, d2, d3);
        }
        return super.mouseScrolled(d, d1, d2, d3);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.leftWaypointList.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void init() {
        super.init();
        this.leftWaypointList = (WaypointListWidget)this.addRenderableWidget((GuiEventListener)new WaypointListWidget(73, 100, this.width / 2 - 86, this.height / 2 - 93, 16, this.getTopSlotItem(), false, 70, 16));
        this.leftWaypointList.setRenderScrollbar(false);
        this.rightWaypointList = (WaypointListWidget)this.addRenderableWidget((GuiEventListener)new WaypointListWidget(73, 100, this.width / 2 + 13, this.height / 2 - 93, 16, this.getBottomSlotItem(), false, 70, 16));
        this.rightWaypointList.setRenderScrollbar(false);
        Button.OnPress onPress = button -> {
            WaypointListWidget widget;
            WaypointListWidget.WaypointEntry entry;
            GuiEventListener listener;
            Optional optional = this.getChildAt(button.getX(), button.getY());
            if (optional.isPresent() && (listener = (GuiEventListener)optional.get()) instanceof WaypointListWidget && (entry = (WaypointListWidget.WaypointEntry)(widget = (WaypointListWidget)listener).getEntryAtPosition(button.getX(), button.getY())) != null) {
                Side side = ((Object)((Object)widget)).equals((Object)this.leftWaypointList) ? Side.LEFT : Side.RIGHT;
                this.selectedWaypoint = new Pair((Object)entry.waypoint, (Object)side);
            }
        };
        this.leftWaypointList.setOnPress(onPress);
        this.rightWaypointList.setOnPress(onPress);
        this.copy = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.workbench.copy"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, true, false);
            }
        }).bounds(this.width / 2 - 175, this.height / 2 - 10, 80, 16).build());
        this.moveTo = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.workbench.move"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, false, false);
                this.selectedWaypoint = null;
            }
        }).bounds(this.width / 2 - 175, this.height / 2 + 8, 80, 16).build());
        this.delete = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ricksportalgun.button.delete"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, false, true);
                this.selectedWaypoint = null;
            }
        }).bounds(this.width / 2 - 175, this.height / 2 + 26, 80, 16).build());
        PGItemButton skin = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 91, this.height / 2 - 105, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.skin"), button -> this.setScreen(1), PGItems.PORTAL_GUN.getDefaultInstance()));
        skin.setRenderBackground(false);
        PGItemButton waypoint = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 91, this.height / 2 - 80, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.waypoint"), button -> {}, PGItems.DATA_CARD.getDefaultInstance()));
        waypoint.setRenderBackground(false);
        PGItemButton craft = (PGItemButton)this.addRenderableWidget((GuiEventListener)new PGItemButton(this.width / 2 + 91, this.height / 2 - 55, 24, 24, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.craft"), button -> this.setScreen(2), Items.CRAFTING_TABLE.getDefaultInstance()));
        craft.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)skin, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.skin"));
        GuiHelper.setTooltip((AbstractWidget)waypoint, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.waypoint"));
        GuiHelper.setTooltip((AbstractWidget)craft, (Component)Component.translatable((String)"menu.ricksportalgun.workbench.craft"));
        GuiHelper.setTooltip((AbstractWidget)this.copy, (Component)Component.translatable((String)"tooltip.ricksportalgun.button.copy"));
        GuiHelper.setTooltip((AbstractWidget)this.moveTo, (Component)Component.translatable((String)"tooltip.ricksportalgun.button.move"));
        GuiHelper.setTooltip((AbstractWidget)this.delete, (Component)Component.translatable((String)"tooltip.ricksportalgun.button.delete"));
    }

    private void sendPacket(Waypoint waypoint, boolean copy, boolean delete) {
        SBWorkbenchWaypointEditPackage packet = new SBWorkbenchWaypointEditPackage(waypoint, this.selectedWaypoint.getB() == Side.LEFT, copy, delete);
        PGHelper.sendPacketToServer(packet);
    }

    private ItemStack getTopSlotItem() {
        return ((WaypointTransferMenu)this.menu).getSlot(36).getItem();
    }

    private ItemStack getBottomSlotItem() {
        return ((WaypointTransferMenu)this.menu).getSlot(37).getItem();
    }

    private ItemStack getItem(Side side) {
        return side == Side.LEFT ? this.getTopSlotItem() : this.getBottomSlotItem();
    }

    public void containerTick() {
        super.containerTick();
        ItemStack leftStack = this.getTopSlotItem();
        ItemStack rightStack = this.getBottomSlotItem();
        if (this.leftWaypointList != null) {
            this.leftWaypointList.refreshEntries(leftStack);
        }
        if (this.rightWaypointList != null) {
            this.rightWaypointList.refreshEntries(rightStack);
        }
        if (this.selectedWaypoint != null && (this.selectedWaypoint.getB() == Side.LEFT && leftStack.isEmpty() || this.selectedWaypoint.getB() == Side.RIGHT && rightStack.isEmpty())) {
            this.selectedWaypoint = null;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        GuiHelper.renderWidgets(graphics, mouseX, mouseY, delta, new AbstractWidget[]{this.leftWaypointList, this.rightWaypointList});
        if (this.selectedWaypoint != null) {
            this.delete.render(graphics, mouseX, mouseY, delta);
            ItemStack opposite = this.getItem(((Side)((Object)this.selectedWaypoint.getB())).opposite());
            if (!opposite.isEmpty() && (!opposite.is(PGTags.Items.PORTAL_GUNS) || opposite.is(PGTags.Items.PORTAL_GUNS) && ((Boolean)opposite.getOrDefault(PGDataComponents.HAS_WAYPOINTS, (Object)false)).booleanValue())) {
                this.copy.render(graphics, mouseX, mouseY, delta);
                this.moveTo.render(graphics, mouseX, mouseY, delta);
            }
            this.renderWaypointInfo(graphics, mouseX, mouseY, delta);
        }
    }

    private void renderWaypointInfo(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Waypoint waypoint = (Waypoint)this.selectedWaypoint.getA();
        GuiHelper.drawWhiteString(graphics, (Component)Component.translatable((String)"ricksportalgun.name", (Object[])new Object[]{""}), this.width / 2 - 172, this.height / 2 - 96);
        GuiHelper.renderScrollingString(graphics, (Component)Component.literal((String)waypoint.getName()), this.width / 2 - 172, this.height / 2 - 84, this.width / 2 - 100, this.height / 2 - 74, Color.WHITE.getRGB());
        GuiHelper.drawWhiteString(graphics, (Component)Component.translatable((String)"ricksportalgun.dimension", (Object[])new Object[]{""}), this.width / 2 - 172, this.height / 2 - 72);
        GuiHelper.renderScrollingString(graphics, (Component)Component.literal((String)waypoint.getDimension()), this.width / 2 - 172, this.height / 2 - 60, this.width / 2 - 100, this.height / 2 - 50, Color.WHITE.getRGB());
        GuiHelper.drawWhiteString(graphics, (Component)Component.translatable((String)"ricksportalgun.x", (Object[])new Object[]{waypoint.getX()}), this.width / 2 - 172, this.height / 2 - 48);
        GuiHelper.drawWhiteString(graphics, (Component)Component.translatable((String)"ricksportalgun.y", (Object[])new Object[]{waypoint.getY()}), this.width / 2 - 172, this.height / 2 - 36);
        GuiHelper.drawWhiteString(graphics, (Component)Component.translatable((String)"ricksportalgun.z", (Object[])new Object[]{waypoint.getZ()}), this.width / 2 - 172, this.height / 2 - 24);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.selectedWaypoint != null) {
            graphics.blit(RenderType::guiTextured, WP_INFO_BG, this.width / 2 - 180, y, 0.0f, 0.0f, 128, 256, 128, 256);
        }
        graphics.blit(RenderType::guiTextured, BG, x + 12, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public Side opposite() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

