/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.block.PortalDispenserBlock;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.menu.PortalDispenserMenu;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PortalDispenserBlockEntity
extends BaseContainerBlockEntity {
    public static final String TAG_FUEL = "Fuel";
    public static final String TAG_MAX_FUEL = "MaxFuel";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_DEST_DIM = "DestinationDim";
    public static final String TAG_DEST_BPOS = "DestinationPos";
    public static final String TAG_DIRECTION = "Direction";
    private Direction dir = Direction.NORTH;
    private int fuel = 16;
    private int maxFuel = 16;
    private String desDim = "minecraft:overworld";
    private BlockPos desPos = BlockPos.ZERO;
    protected final ContainerData dataAccess;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public PortalDispenserBlockEntity(BlockPos pos, BlockState blockState) {
        super(PGBlockEntities.PORTAL_DISPENSER, pos, blockState);
        this.dataAccess = new ContainerData(){

            public int get(int i) {
                switch (i) {
                    case 0: {
                        return PortalDispenserBlockEntity.this.fuel;
                    }
                    case 1: {
                        return PortalDispenserBlockEntity.this.maxFuel;
                    }
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        PortalDispenserBlockEntity.this.fuel = value;
                        break;
                    }
                    case 1: {
                        PortalDispenserBlockEntity.this.maxFuel = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void setDestination(String dimension, BlockPos pos) {
        this.desDim = dimension;
        this.desPos = pos;
    }

    public BlockPos getDestinationPos() {
        return this.desPos;
    }

    public String getDestinationDim() {
        return this.desDim;
    }

    public void setChanged() {
        ItemStack stack;
        if (!this.hasFuel() && (stack = (ItemStack)this.items.getFirst()).is(PGItems.PORTAL_FLUID)) {
            stack.shrink(1);
            this.fuel = this.maxFuel;
        }
        super.setChanged();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"menu.ricksportalgun.portal_dispenser");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.items = list;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new PortalDispenserMenu(i, inventory, (Container)this, this.dataAccess, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public int getFuel() {
        return this.fuel;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setFuel(int fuel) {
        this.fuel = Math.min(this.getMaxFuel(), fuel);
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
    }

    public void onActivation(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            BlockState state = level.getBlockState(pos);
            Direction direction = (Direction)state.getValue((Property)PortalDispenserBlock.FACING);
            BlockPos portalPos = pos;
            if (this.hasFuel()) {
                ResourceLocation dim;
                ServerLevel destLevel;
                for (int j = 0; j < 4 && level.getBlockState((portalPos = pos.relative(direction, j)).relative(direction, 1)).isAir(); ++j) {
                }
                if (!this.getDestinationDim().isEmpty() && this.getDestinationPos() != null && LevelHelper.canPortalTo(destLevel = LevelHelper.getServerWorld(level, LevelHelper.getWorldKey(dim = ResourceLocation.parse((String)this.getDestinationDim()))), this.getDestinationPos(), null)) {
                    Vec3 vec = Vec3.atCenterOf((Vec3i)portalPos).add((double)direction.getStepX() * 0.4, (double)direction.getStepY() * 0.4, (double)direction.getStepZ() * 0.4);
                    PortalEntity portal = new PortalEntity(level, vec, direction, this.dir, 3.0f);
                    PortalEntity exitPortal = new PortalEntity((Level)destLevel, new Vec3((Vec3i)this.getDestinationPos()), direction, this.dir, 3.0f);
                    if (!portal.isFlat()) {
                        portal.setYRot(this.dir.toYRot());
                        exitPortal.setYRot(this.dir.toYRot());
                    }
                    portal.setHopLocation(dim, this.getDestinationPos());
                    exitPortal.setHopLocation(dim, portal.blockPosition());
                    if (destLevel.addFreshEntity((Entity)exitPortal)) {
                        level.addFreshEntity((Entity)portal);
                        this.decreaseFuel(1);
                    }
                }
            }
        }
    }

    public void setDirection(Direction direction) {
        this.dir = direction;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fuel = tag.getInt(TAG_FUEL);
        this.maxFuel = tag.getInt(TAG_MAX_FUEL);
        this.desPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)TAG_DEST_BPOS).orElse(BlockPos.ZERO);
        this.desDim = tag.getString(TAG_DEST_DIM);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.dir = Direction.fromYRot((double)tag.getDouble(TAG_DIRECTION));
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt(TAG_FUEL, this.fuel);
        tag.putInt(TAG_MAX_FUEL, this.maxFuel);
        tag.putString(TAG_DEST_DIM, this.desDim);
        tag.put(TAG_DEST_BPOS, NbtUtils.writeBlockPos((BlockPos)this.desPos));
        tag.putDouble(TAG_DIRECTION, (double)this.dir.toYRot());
    }

    public int getContainerSize() {
        return 1;
    }
}

