/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGDamageTypes;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ExplosiveItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.defineId(ExplosiveItemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ExplosiveItemEntity(EntityType<? extends ItemEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FUSE, (Object)PGHelper.seconds(10));
    }

    public ExplosiveItemEntity(Level level, BlockPos pos, ItemStack stack) {
        this(PGEntities.EXPLOSIVE_ITEM, level);
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
        this.setItem(stack);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(FUSE);
    }

    public void setFuse(int i) {
        this.entityData.set(FUSE, (Object)i);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.getFuse() > 0) {
                int i = this.getFuse();
                this.setFuse(--i);
            } else {
                BlockPos pos = this.blockPosition();
                boolean kaboom = level2.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                Level.ExplosionInteraction interaction = kaboom ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
                EntityBasedExplosionDamageCalculator calc = new EntityBasedExplosionDamageCalculator((Entity)this);
                level2.explode((Entity)this, PGDamageTypes.of((Level)level2, PGDamageTypes.SELF_DESTRUCT), (ExplosionDamageCalculator)calc, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0f, true, interaction);
                this.kill(level2);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Fuse", this.getFuse());
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Fuse")) {
            this.setFuse(compound.getInt("Fuse"));
        }
        super.readAdditionalSaveData(compound);
    }
}

