/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.entity.ExplosiveItemEntity;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class PGEntities {
    private static final Map<ResourceLocation, EntityType<?>> ALL = new HashMap();
    public static final EntityType<PortalEntity> PORTAL = PGEntities.register("portal", EntityType.Builder.of(PortalEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 2.0f));
    public static final EntityType<ExplosiveItemEntity> EXPLOSIVE_ITEM = PGEntities.register("explosive_item", EntityType.Builder.of(ExplosiveItemEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).noLootTable().eyeHeight(0.2125f).clientTrackingRange(6).updateInterval(20));

    private static <E extends Entity> EntityType<E> register(String name, EntityType.Builder<E> builder) {
        EntityType type = builder.build(PGEntities.keyOf(name));
        ALL.put(PGHelper.id(name), type);
        return type;
    }

    public static void init(BiConsumer<EntityType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, EntityType<?>> e : ALL.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static ResourceKey<EntityType<?>> keyOf(String id) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)PGHelper.id(id));
    }
}

