/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.init.PGBlocks;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGFoods;
import com.jdolphin.ricksportalgun.common.item.DataCardItem;
import com.jdolphin.ricksportalgun.common.item.PortalFluidItem;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.CreativeUpgradeItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.SimpleConditionalUpgradeItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.SimpleUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.PGCreativeModeTabs;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.level.Level;

public class PGItems {
    private static final Map<ResourceLocation, Item> ALL = new HashMap<ResourceLocation, Item>();
    public static final Map<Item, ResourceKey<CreativeModeTab>> TABS = new LinkedHashMap<Item, ResourceKey<CreativeModeTab>>();
    public static final Item PORTAL_GUN = PGItems.registerGun("portal_gun");
    public static final Item GOLDEN_PORTAL_GUN = PGItems.registerGun("golden_portal_gun", Color.YELLOW, null);
    public static final Item PRIME_PORTAL_GUN = PGItems.registerGun("prime_portal_gun", Color.GREEN, null);
    public static final Item PORTAL_FLUID = PGItems.registerFluid("portal_fluid");
    public static final Item BOOTLEG_PORTAL_FLUID = PGItems.registerFluid("bootleg_portal_fluid");
    public static final Item QUANTUM_LEAP_ELIXIR = PGItems.registerFluid("quantum_leap_elixir");
    public static final Item DATA_CARD = PGItems.register("data_card", DataCardItem::new, new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item PORTAL_DISPENSER = PGItems.register("portal_dispenser", properties -> new BlockItem(PGBlocks.PORTAL_DISPENSER, properties), new Item.Properties(), PGCreativeModeTabs.REDSTONE_BLOCKS);
    public static final Item PORTAL_GUN_WORKBENCH = PGItems.register("portal_gun_workbench", properties -> new BlockItem(PGBlocks.GUN_WORKBENCH, properties), new Item.Properties(), PGCreativeModeTabs.FUNCTIONAL_BLOCKS);
    public static final Item SUBETHER_BARRIER = PGItems.register("subether_barrier", properties -> new BlockItem(PGBlocks.SUBETHER_BARRIER, properties), new Item.Properties(), PGCreativeModeTabs.REDSTONE_BLOCKS);
    public static final Item CIRCUIT_BOARD = PGItems.register("circuitboard", Item::new, new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item DISC_TEMPLATE = PGItems.register("disc_template", Item::new, new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item CREATIVE_UPGRADE = PGItems.register("upgrade_creative", CreativeUpgradeItem::new, new Item.Properties().rarity(Rarity.EPIC), PGCreativeModeTabs.INGREDIENTS);
    public static final Item DURABILITY_UPGRADE = PGItems.register("upgrade_durability", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_FIRE))), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item WAYPOINT_UPGRADE = PGItems.register("upgrade_waypoint", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.HAS_WAYPOINTS, (Object)true)), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item DIM_UPGRADE = PGItems.register("upgrade_dimension_mk1", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.EXTRA_DIMENSIONS, (Object)true)), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item BETTER_DIM_UPGRADE = PGItems.register("upgrade_dimension_mk2", properties -> new SimpleConditionalUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.EXTRA_DIMENSIONS_2, (Object)true), (stack, portalGun) -> (Boolean)stack.getOrDefault(PGDataComponents.EXTRA_DIMENSIONS, (Object)false), (Component)Component.translatable((String)"error.ricksportalgun.upgrade.needs_dimension")), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item SETTINGS_UPGRADE = PGItems.register("upgrade_settings", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.SETTINGS, (Object)true)), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item FUEL_UPGRADE = PGItems.register("upgrade_fuel", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.MAX_FUEL, (Object)128)), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item BIOME_LOC_UPGRADE = PGItems.register("upgrade_biome_locator", properties -> new SimpleUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.BIOME_LOC, (Object)true)), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item PLAYER_LOC_UPGRADE = PGItems.register("upgrade_player_locator", properties -> new SimpleConditionalUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.PLAYER_LOC, (Object)true), (stack, item) -> (Boolean)stack.getOrDefault(PGDataComponents.BIOME_LOC, (Object)false), (Component)Component.translatable((String)"error.ricksportalgun.upgrade.needs_biome")), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);
    public static final Item STRUCTURE_LOC_UPGRADE = PGItems.register("upgrade_structure_locator", properties -> new SimpleConditionalUpgradeItem((Item.Properties)properties, (stack, portalGun) -> stack.set(PGDataComponents.STRUCTURE_LOC, (Object)true), (stack, item) -> (Boolean)stack.getOrDefault(PGDataComponents.PLAYER_LOC, (Object)false), (Component)Component.translatable((String)"error.ricksportalgun.upgrade.needs_player")), new Item.Properties(), PGCreativeModeTabs.INGREDIENTS);

    private static Item registerGun(String name) {
        return PGItems.registerGun(name, Color.GREEN, PGCreativeModeTabs.TOOLS_AND_UTILITIES);
    }

    private static Item registerGun(String name, Color color, ResourceKey<CreativeModeTab> tab) {
        return PGItems.register(name, PortalGunItem::new, new Item.Properties().stacksTo(1).component(PGDataComponents.PORTAL_COLOUR, (Object)color.getRGB()).component(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)color.getRGB()).component(PGDataComponents.BOOTLEG, (Object)false).component(PGDataComponents.WAYPOINTS, List.of()).component(PGDataComponents.PORTAL_SIZE, (Object)Float.valueOf(1.0f)).component(PGDataComponents.MAX_FUEL, (Object)64).component(PGDataComponents.LOCK, (Object)false).component(PGDataComponents.HAS_WAYPOINTS, (Object)false).component(PGDataComponents.EXTRA_DIMENSIONS, (Object)false).component(PGDataComponents.SETTINGS, (Object)false).component(PGDataComponents.BIOME_LOC, (Object)false).component(PGDataComponents.PLAYER_LOC, (Object)false).component(PGDataComponents.STRUCTURE_LOC, (Object)false).component(PGDataComponents.PORTAL_POS, (Object)BlockPos.ZERO).component(PGDataComponents.PORTAL_DIM, (Object)Level.OVERWORLD.location()), tab);
    }

    private static Item registerFluid(String name) {
        return PGItems.register(name, PortalFluidItem::new, new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).food(PGFoods.PORTAL_FLUID, PGFoods.PORTAL_FLUID_CONSUMABLE), PGCreativeModeTabs.FOOD_AND_DRINKS);
    }

    private static Item register(String name, Function<Item.Properties, Item> factory, Item.Properties properties, ResourceKey<CreativeModeTab> tab) {
        Item item = factory.apply(properties.setId(PGItems.keyOf(name)));
        TABS.put(item, tab);
        ALL.put(PGHelper.id(name), item);
        return item;
    }

    public static void init(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Item> e : ALL.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static ResourceKey<Item> keyOf(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)PGHelper.id(id));
    }
}

