/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PortalGunTypeRegistry {
    public static final ArrayList<PortalGunType> PORTAL_GUN_TYPES = Lists.newArrayList();
    public static final ArrayList<PortalGunType> CLIENT_TYPES = Lists.newArrayList();

    public static PortalGunType getPortalGunType(ItemStack stack) {
        return (PortalGunType)stack.getOrDefault(PGDataComponents.PORTAL_GUN_TYPE, (Object)PORTAL_GUN_TYPES.getFirst());
    }

    public static void add(PortalGunType type) {
        PORTAL_GUN_TYPES.add(type);
    }

    public static PortalGunType getPortalGunType(ResourceLocation id) {
        for (PortalGunType portalGunType : PORTAL_GUN_TYPES) {
            if (!id.equals((Object)portalGunType.id())) continue;
            return portalGunType;
        }
        return PORTAL_GUN_TYPES.getFirst();
    }
}

