/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.item.upgrade.AbstractUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PortalGunItem
extends Item
implements IWaypointStorage {
    public PortalGunItem(Item.Properties properties) {
        super(properties);
    }

    public static int getMaxFuel(ItemStack stack) {
        return (Integer)stack.getOrDefault(PGDataComponents.MAX_FUEL, (Object)64);
    }

    public static int getFuel(ItemStack stack) {
        return (Integer)stack.getOrDefault(PGDataComponents.FUEL, (Object)64);
    }

    public static void lowerFuel(ItemStack stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        int j = PortalGunItem.getMaxFuel(stack) - i;
        int fuel = Math.max(0, i - amount);
        stack.set(PGDataComponents.FUEL, (Object)fuel);
    }

    public static void setPrimaryDye(ItemStack stack, int color) {
        stack.set(PGDataComponents.PRIMARY_DYE, (Object)color);
    }

    public static void setSecondaryDye(ItemStack stack, int color) {
        stack.set(PGDataComponents.SECONDARY_DYE, (Object)color);
    }

    public static int getPrimaryDye(ItemStack stack) {
        return (Integer)stack.getOrDefault(PGDataComponents.PRIMARY_DYE, (Object)0);
    }

    public static int getSecondaryDye(ItemStack stack) {
        return (Integer)stack.getOrDefault(PGDataComponents.SECONDARY_DYE, (Object)0);
    }

    public static void setCode(ItemStack stack, String code) {
        stack.set(PGDataComponents.CODE, (Object)code);
    }

    public static String getCode(ItemStack stack) {
        return (String)stack.getOrDefault(PGDataComponents.CODE, (Object)"");
    }

    public static void refillFuel(ItemStack stack) {
        stack.set(PGDataComponents.FUEL, (Object)PortalGunItem.getMaxFuel(stack));
    }

    public static void migrateDamage(ItemStack stack) {
        if (stack.has(DataComponents.DAMAGE)) {
            int fuel = PortalGunItem.getMaxFuel(stack) - (Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0);
            stack.set(PGDataComponents.FUEL, (Object)fuel);
            stack.remove(DataComponents.DAMAGE);
        }
    }

    public static boolean refuel(ItemStack stack, Player player) {
        InteractionHand pgHand = PGHelper.getPortalGunHand(player);
        InteractionHand fluidHand = PGHelper.getOppositeHand(pgHand);
        ItemStack gunStack = player.getItemInHand(pgHand);
        ItemStack fluidStack = player.getItemInHand(fluidHand);
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && gunStack.is(PGTags.Items.PORTAL_GUNS)) {
            if (fluidStack.is(PGItems.PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                fluidStack.shrink(1);
                stack.set(PGDataComponents.BOOTLEG, (Object)false);
                return true;
            }
            if (fluidStack.is(PGItems.BOOTLEG_PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                stack.set(PGDataComponents.BOOTLEG, (Object)true);
                fluidStack.shrink(1);
                return true;
            }
        }
        return false;
    }

    public static void setPortalGunType(ItemStack stack, PortalGunType type) {
        stack.set(PGDataComponents.PORTAL_GUN_TYPE, (Object)type);
        stack.set(DataComponents.ITEM_MODEL, (Object)type.model());
        if (stack.getCustomName() == null) {
            stack.set(DataComponents.ITEM_NAME, (Object)type.name());
        }
        PortalGunItem.setDefaultColor(stack, type.color());
    }

    public static PortalGunType getPortalGunType(ItemStack stack) {
        return (PortalGunType)stack.getOrDefault(PGDataComponents.PORTAL_GUN_TYPE, (Object)PortalGunType.DEFAULT);
    }

    private Vec3 getLocation(Level level, BlockPos bPos, Direction dir, Vec3 loc) {
        if (this.isAir(level, bPos.below()) && dir == Direction.DOWN) {
            return loc.add(0.0, -0.2, 0.0);
        }
        if (dir.equals((Object)Direction.UP)) {
            return loc;
        }
        if (!this.isAir(level, bPos.relative(dir))) {
            switch (dir) {
                case NORTH: {
                    Vec3 vec = bPos.north().getBottomCenter();
                    loc = vec.add(0.0, 0.0, 0.4);
                    break;
                }
                case SOUTH: {
                    Vec3 vec = bPos.south().getBottomCenter();
                    loc = vec.add(0.0, 0.0, -0.4);
                    break;
                }
                case WEST: {
                    Vec3 vec = bPos.west().getBottomCenter();
                    loc = vec.add(0.4, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    Vec3 vec = bPos.east().getBottomCenter();
                    loc = vec.add(-0.4, 0.0, 0.0);
                }
            }
        } else {
            float x;
            float f = dir.getAxis().equals((Object)Direction.Axis.X) ? (dir.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 0.1f : -0.1f) : (x = 0.0f);
            float z = dir.getAxis().equals((Object)Direction.Axis.Z) ? (dir.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 0.1f : -0.1f) : 0.0f;
            loc = new Vec3(loc.x() + (double)x, (double)bPos.getY(), loc.z() + (double)z);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        Direction dir;
        ItemStack stack = player.getItemInHand(hand);
        ItemStack oppositeStack = player.getItemInHand(PGHelper.getOppositeHand(hand));
        BlockHitResult hitResult = PortalGunItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (level.isClientSide()) return InteractionResult.FAIL;
        if (!(player instanceof ServerPlayer)) return InteractionResult.FAIL;
        PortalGunItem.migrateDamage(stack);
        PortalGunItem.migrateNBT(stack);
        if (!PGHelper.canPlayerAccessGun(player, stack)) return InteractionResult.SUCCESS;
        Item item = oppositeStack.getItem();
        if (item instanceof AbstractUpgradeItem) {
            AbstractUpgradeItem upgrade = (AbstractUpgradeItem)item;
            InteractionResult result = upgrade.applyUpgrade(player, stack, this);
            if (player.isCreative()) return result;
            oppositeStack.shrink(1);
            return result;
        }
        if (PortalGunItem.refuel(stack, player)) return InteractionResult.SUCCESS;
        if (PortalGunItem.getFuel(stack) <= 0) return InteractionResult.SUCCESS;
        Vec3 loc = hitResult.getLocation();
        if (hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
            dir = hitResult.getDirection();
            BlockPos bPos = hitResult.getBlockPos();
            loc = this.getLocation(level, bPos, dir, loc);
        }
        dir = hitResult.getDirection();
        Direction facing = player.getDirection();
        float size = ((Float)stack.getOrDefault(PGDataComponents.PORTAL_SIZE, (Object)Float.valueOf(1.0f))).floatValue();
        int age = (Integer)stack.getOrDefault(PGDataComponents.PORTAL_LIFETIME, (Object)10);
        PortalEntity portal = new PortalEntity(level, loc, dir, facing, size);
        PortalEntity exPortal = new PortalEntity(level, PortalGunItem.getHopCoords(stack).above().getBottomCenter(), dir, facing, size);
        ResourceKey<Level> key = LevelHelper.getWorldKey((ResourceLocation)stack.getOrDefault(PGDataComponents.PORTAL_DIM, (Object)Level.OVERWORLD.location()));
        ServerLevel serverlevel = LevelHelper.getServerWorld(level, key);
        this.doForBoth(entity -> entity.setLifetime(PGHelper.seconds(age)), portal, exPortal);
        Component customName = stack.getCustomName();
        if (customName != null) {
            this.doForBoth(entity -> entity.setCustomName(customName), portal, exPortal);
        }
        portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
        exPortal.setHopLocation(level.dimension().location(), portal.blockPosition());
        int color = PortalGunItem.getColor(stack);
        this.doForBoth(entity -> entity.setColor(color), portal, exPortal);
        boolean bootleg = (Boolean)stack.getOrDefault(PGDataComponents.BOOTLEG, (Object)false);
        this.doForBoth(entity -> entity.setBootleg(bootleg), portal, exPortal);
        if (LevelHelper.isBlenderDestination(PortalGunItem.getHopDimension(stack).toString())) {
            if (!portal.isFlat()) {
                portal.setYRot(player.getYRot());
            }
            level.addFreshEntity((Entity)portal);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown(stack, 60);
            if (player.isCreative()) return InteractionResult.SUCCESS;
            PortalGunItem.lowerFuel(stack, 1);
            return InteractionResult.SUCCESS;
        }
        if (!LevelHelper.canPortalTo(serverlevel, PortalGunItem.getHopCoords(stack), stack)) {
            PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.dragon");
            return InteractionResult.SUCCESS;
        }
        if (PortalGunItem.canBypassDragon(stack) || !LevelHelper.endHasDragons((ServerLevel)level) && !LevelHelper.endHasDragons(serverlevel)) {
            if (!portal.isFlat()) {
                this.doForBoth(entity -> entity.setYRot(player.getYRot()), portal, exPortal);
            }
            serverlevel.addFreshEntity((Entity)exPortal);
            level.addFreshEntity((Entity)portal);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown(stack, 60);
            if (player.isCreative()) return InteractionResult.SUCCESS;
            PortalGunItem.lowerFuel(stack, 1);
            return InteractionResult.SUCCESS;
        }
        PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.unreachable");
        return InteractionResult.FAIL;
    }

    private void doForBoth(Consumer<PortalEntity> consumer, PortalEntity a, PortalEntity b) {
        consumer.accept(a);
        consumer.accept(b);
    }

    public static boolean canBypassDragon(ItemStack stack) {
        return (Boolean)stack.getOrDefault(PGDataComponents.EXTRA_DIMENSIONS_2, (Object)false);
    }

    private boolean isAir(Level level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext pContext, List<Component> toolTips, @NotNull TooltipFlag pTooltipFlag) {
        List list = (List)stack.getOrDefault(PGDataComponents.WAYPOINTS, List.of());
        if (!Screen.hasShiftDown()) {
            toolTips.add((Component)Component.translatable((String)"ricksportalgun.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(stack).getX(), PortalGunItem.getHopCoords(stack).getY(), PortalGunItem.getHopCoords(stack).getZ()}).withStyle(ChatFormatting.GRAY));
            toolTips.add((Component)Component.translatable((String)"ricksportalgun.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).withStyle(ChatFormatting.GRAY));
            toolTips.add((Component)Component.translatable((String)"tooltip.ricksportalgun.fuel", (Object[])new Object[]{PortalGunItem.getFuel(stack), PortalGunItem.getMaxFuel(stack)}).withStyle(ChatFormatting.GRAY));
        } else {
            toolTips.add((Component)Component.translatable((String)"tooltip.ricksportalgun.waypoints", (Object[])new Object[]{list.size()}).withStyle(ChatFormatting.GRAY));
            if (stack.has(PGDataComponents.PRIMARY_DYE) || stack.has(PGDataComponents.SECONDARY_DYE)) {
                toolTips.add((Component)Component.translatable((String)"item.dyed", (Object[])new Object[]{list.size()}).withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            }
        }
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return PortalGunItem.getColor(stack);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public static int getColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(PGDataComponents.PORTAL_COLOUR, (Object)Color.GREEN.getRGB());
    }

    public static void setDefaultColor(ItemStack stack, int color) {
        stack.set(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)color);
    }

    public static void setStyle(ItemStack stack, PortalGunStyle style) {
        stack.set(PGDataComponents.PORTAL_GUN_STYLE, (Object)style);
    }

    public static void setColor(ItemStack stack, int color) {
        stack.set(PGDataComponents.PORTAL_COLOUR, (Object)color);
    }

    public static void setHopLocation(ItemStack stack, ResourceLocation dimension, BlockPos pos) {
        stack.set(PGDataComponents.PORTAL_DIM, (Object)dimension);
        stack.set(PGDataComponents.PORTAL_POS, (Object)pos);
    }

    public static ResourceLocation getHopDimension(ItemStack stack) {
        return (ResourceLocation)stack.getOrDefault(PGDataComponents.PORTAL_DIM, (Object)Level.OVERWORLD.location());
    }

    public static BlockPos getHopCoords(ItemStack stack) {
        return (BlockPos)stack.getOrDefault(PGDataComponents.PORTAL_POS, (Object)BlockPos.ZERO);
    }

    public static void migrateNBT(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            String dim = "PortalDimension";
            String fuel = "Fuel";
            String pos = "PortalPos";
            String bootleg = "Bootleg";
            String color = "Color";
            String waypoints = "Waypoints";
            String lock = "Lock";
            String owner = "Owner";
            String defaultColor = "DefaultColor";
            CompoundTag tag = data.getUnsafe();
            if (tag.contains(dim)) {
                String dimension = tag.getString(dim);
                ResourceLocation rl = ResourceLocation.parse((String)dimension);
                stack.set(PGDataComponents.PORTAL_DIM, (Object)rl);
                tag.remove(dim);
            }
            if (tag.contains(fuel)) {
                int f = tag.getInt(fuel);
                stack.set(PGDataComponents.FUEL, (Object)f);
                tag.remove(fuel);
            }
            if (tag.contains(pos)) {
                BlockPos blockPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)pos).get();
                stack.set(PGDataComponents.PORTAL_POS, (Object)blockPos);
                tag.remove(pos);
            }
            if (tag.contains(bootleg)) {
                boolean acid = tag.getBoolean(bootleg);
                stack.set(PGDataComponents.BOOTLEG, (Object)acid);
                tag.remove(bootleg);
            }
            if (tag.contains(color)) {
                int colour = tag.getInt(color);
                stack.set(PGDataComponents.PORTAL_COLOUR, (Object)colour);
                tag.remove(color);
            }
            if (tag.contains(waypoints)) {
                ListTag listTag = tag.getList(waypoints, 8);
                List<Waypoint> waypointList = listTag.stream().map(Tag::getAsString).map(Waypoint::getWaypoint).toList();
                stack.set(PGDataComponents.WAYPOINTS, waypointList);
                tag.remove(waypoints);
            }
            if (tag.contains(lock)) {
                boolean locked = tag.getBoolean(lock);
                stack.set(PGDataComponents.LOCK, (Object)locked);
                tag.remove(lock);
            }
            if (tag.contains(owner)) {
                String own = tag.getString(owner);
                stack.set(PGDataComponents.OWNER, (Object)own);
                tag.remove(owner);
            }
            if (tag.contains(defaultColor)) {
                int defColour = tag.getInt(defaultColor);
                stack.set(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)defColour);
                tag.remove(defaultColor);
            }
        }
    }
}

