/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.menu.workbench;

import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.menu.workbench.AbstractWorkbenchMenu;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SkinSelectorMenu
extends AbstractWorkbenchMenu {
    private Container container;
    private final ContainerLevelAccess access;

    public SkinSelectorMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(10), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.NULL);
    }

    public SkinSelectorMenu(int i, Inventory inventory, Container container, ContainerData data, ContainerLevelAccess access) {
        super(PGMenuTypes.WORKBENCH_SKIN_SELECTOR, i, access);
        this.container = container;
        this.access = access;
        SkinSelectorMenu.checkContainerDataCount((ContainerData)data, (int)2);
        SkinSelectorMenu.checkContainerSize((Container)container, (int)10);
        this.addInventoryExtendedSlots((Container)inventory, 25, 110);
        this.addInventoryHotbarSlots((Container)inventory, 25, 168);
        this.addSlots(container);
    }

    public void setPortalGunType(Player player, PortalGunType type) {
        this.access.execute((level, pos) -> {
            DyeItem dyeItem;
            ItemStack gun = this.getSlot(36).getItem();
            ItemStack dye1 = this.getSlot(37).getItem();
            ItemStack dye2 = this.getSlot(38).getItem();
            int primary = 0;
            int secondary = 0;
            if (type.tints() >= 2 && !dye1.isEmpty()) {
                if (!dye1.is(Items.WATER_BUCKET)) {
                    dyeItem = (DyeItem)dye1.getItem();
                    primary = dyeItem.getDyeColor().getTextureDiffuseColor();
                    if (!player.isCreative()) {
                        dye1.shrink(1);
                    }
                } else {
                    gun.remove(PGDataComponents.PRIMARY_DYE);
                    if (!player.isCreative()) {
                        this.getSlot(37).set(dye1.getItem().getCraftingRemainder());
                    }
                }
            }
            if (type.tints() >= 3 && !dye2.isEmpty()) {
                if (!dye2.is(Items.WATER_BUCKET)) {
                    dyeItem = (DyeItem)dye2.getItem();
                    secondary = dyeItem.getDyeColor().getTextureDiffuseColor();
                    if (!player.isCreative()) {
                        dye2.shrink(1);
                    }
                } else {
                    gun.remove(PGDataComponents.SECONDARY_DYE);
                    if (!player.isCreative()) {
                        this.getSlot(38).set(dye2.getItem().getCraftingRemainder());
                    }
                }
            }
            PortalGunItem.setPortalGunType(gun, type);
            if (primary != 0) {
                PortalGunItem.setPrimaryDye(gun, primary);
            }
            if (secondary != 0) {
                PortalGunItem.setSecondaryDye(gun, secondary);
            }
        });
    }

    protected void addSlots(Container container) {
        final Function<ItemStack, Boolean> bool = stack -> stack.getItem() instanceof DyeItem || stack.is(Items.WATER_BUCKET);
        this.addSlot(new Slot(this, container, 7, 25, 73){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(PGTags.Items.PORTAL_GUNS);
            }
        });
        this.addSlot(new Slot(this, container, 8, 55, 73){

            public boolean mayPlace(ItemStack stack) {
                return (Boolean)bool.apply(stack);
            }
        });
        this.addSlot(new Slot(this, container, 9, 85, 73){

            public boolean mayPlace(ItemStack stack) {
                return (Boolean)bool.apply(stack);
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int i) {
        Slot fromSlot = this.getSlot(i);
        ItemStack fromStack = fromSlot.getItem();
        if (fromStack.getCount() <= 0) {
            fromSlot.set(ItemStack.EMPTY);
        }
        if (!fromSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack copyFromStack = fromStack.copy();
        if (i < 36) {
            if (!this.moveItemStackTo(fromStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (i < 39) {
            if (!this.moveItemStackTo(fromStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.println("Invalid slot index: " + i);
            return ItemStack.EMPTY;
        }
        fromSlot.setChanged();
        fromSlot.onTake(player, fromStack);
        return copyFromStack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

