/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.menu.workbench;

import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.menu.workbench.AbstractWorkbenchMenu;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WaypointTransferMenu
extends AbstractWorkbenchMenu {
    private final Container container;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public WaypointTransferMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(10), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.NULL);
    }

    public WaypointTransferMenu(int i, Inventory inventory, Container container, ContainerData data, ContainerLevelAccess access) {
        super(PGMenuTypes.WORKBENCH_WAYPOINT_TRANSFER, i, access);
        this.data = data;
        this.access = access;
        this.container = container;
        this.addDataSlots(data);
        WaypointTransferMenu.checkContainerSize((Container)container, (int)10);
        WaypointTransferMenu.checkContainerDataCount((ContainerData)data, (int)2);
        this.addInventoryExtendedSlots((Container)inventory, 25, 129);
        this.addInventoryHotbarSlots((Container)inventory, 25, 187);
        this.addSlots(container);
    }

    protected void addSlots(Container container) {
        this.addSlot(new Slot(this, container, 5, 97, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof IWaypointStorage;
            }
        });
        this.addSlot(new Slot(this, container, 6, 97, 73){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof IWaypointStorage;
            }
        });
    }

    public void editWaypoints(Waypoint waypoint, boolean side, boolean copy, boolean remove) {
        this.access.execute((level, pos) -> {
            if (!level.isClientSide) {
                ItemStack left = this.getSlot(36).getItem();
                ItemStack right = this.getSlot(37).getItem();
                if (copy) {
                    if (side) {
                        IWaypointStorage.addWaypoint(right, waypoint);
                    } else {
                        IWaypointStorage.addWaypoint(left, waypoint);
                    }
                } else if (remove) {
                    if (side) {
                        IWaypointStorage.deleteWaypoint(left, waypoint);
                    } else {
                        IWaypointStorage.deleteWaypoint(right, waypoint);
                    }
                } else if (side) {
                    IWaypointStorage.addWaypoint(right, waypoint);
                    IWaypointStorage.deleteWaypoint(left, waypoint);
                } else {
                    IWaypointStorage.addWaypoint(left, waypoint);
                    IWaypointStorage.deleteWaypoint(right, waypoint);
                }
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int i) {
        Slot fromSlot = this.getSlot(i);
        ItemStack fromStack = fromSlot.getItem();
        if (fromStack.getCount() <= 0) {
            fromSlot.set(ItemStack.EMPTY);
        }
        if (!fromSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack copyFromStack = fromStack.copy();
        if (i < 36) {
            if (!this.moveItemStackTo(fromStack, 36, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else if (i < 38) {
            if (!this.moveItemStackTo(fromStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.println("Invalid slot index: " + i);
            return ItemStack.EMPTY;
        }
        fromSlot.setChanged();
        fromSlot.onTake(player, fromStack);
        return copyFromStack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

