/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.entity.ExplosiveItemEntity;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record SBActivateSelfDestructPacket() implements PGPayload
{
    public static final CustomPacketPayload.Type<SBActivateSelfDestructPacket> ID = new CustomPacketPayload.Type(PGHelper.id("activate_self_destruct"));
    public static final StreamCodec<FriendlyByteBuf, SBActivateSelfDestructPacket> CODEC = StreamCodec.unit((Object)new SBActivateSelfDestructPacket());

    @Override
    public void handle(ServerPlayer player) {
        ItemEntity dropped;
        ServerLevel level = player.serverLevel();
        InteractionHand hand = PGHelper.getPortalGunHand((Player)player);
        ItemStack stack = player.getItemInHand(hand);
        ItemStack copy = stack.copy();
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        if ((dropped = player.drop(copy, false)) != null) {
            ExplosiveItemEntity kaboom = new ExplosiveItemEntity((Level)level, dropped.blockPosition(), copy);
            dropped.discard();
            level.addFreshEntity((Entity)kaboom);
            kaboom.setNeverPickUp();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

