/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record SBLocatePacket(String name, int value) implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBLocatePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SBLocatePacket::name, (StreamCodec)ByteBufCodecs.INT, SBLocatePacket::value, SBLocatePacket::new);
    public static final CustomPacketPayload.Type<SBLocatePacket> ID = new CustomPacketPayload.Type(PGHelper.id("locate"));

    @Override
    public void handle(ServerPlayer player) {
        Optional optionalRegistry;
        MinecraftServer server = player.server;
        ServerLevel level = player.serverLevel();
        InteractionHand hand = PGHelper.getPortalGunHand((Player)player);
        ItemStack stack = player.getItemInHand(hand);
        if (this.value == 0) {
            if (!PGConfigHelper.disableBiomeLocating()) {
                optionalRegistry = server.registryAccess().lookup(Registries.BIOME);
                if (optionalRegistry.isPresent()) {
                    ResourceLocation location = ResourceLocation.parse((String)this.name);
                    Pair pair = level.findClosestBiome3d(biomeHolder -> biomeHolder.is(location), player.blockPosition(), 6400, 32, 64);
                    if (pair != null) {
                        BlockPos pos = (BlockPos)pair.getFirst();
                        BlockPos safePos = LevelHelper.getSafePos(pos, level);
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                        PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.biome.not_in_area", (Object[])new Object[]{this.name}));
                    }
                }
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.biome.disabled"));
                return;
            }
        }
        if (this.value == 1) {
            if (!PGConfigHelper.disablePlayerLocating()) {
                ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(this.name);
                if (targetPlayer != null && !targetPlayer.isSpectator()) {
                    BlockPos pos = targetPlayer.blockPosition().above();
                    Vec3 look = Vec3.directionFromRotation((Vec2)new Vec2(45.0f, targetPlayer.getYRot() + 180.0f));
                    double dx = (double)pos.getX() + look.x * 2.0;
                    double dz = (double)pos.getZ() + look.z * 2.0;
                    BlockPos destination = new BlockPos((int)dx, pos.getY(), (int)dz);
                    PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)targetPlayer), destination);
                    PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                } else {
                    PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
                }
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.player.disabled"));
                return;
            }
        }
        if (this.value == 2) {
            if (!PGConfigHelper.disableStructureLocating()) {
                optionalRegistry = server.registryAccess().lookup(Registries.STRUCTURE);
                if (optionalRegistry.isPresent()) {
                    ResourceLocation location;
                    Registry registry = (Registry)optionalRegistry.get();
                    Optional structureReference = registry.get(location = ResourceLocation.parse((String)this.name));
                    if (structureReference.isPresent()) {
                        Structure structure = (Structure)((Holder.Reference)structureReference.get()).value();
                        HolderSet.Direct set = HolderSet.direct((Holder[])new Holder[]{Holder.direct((Object)structure)});
                        Pair pair = level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)set, player.blockPosition(), 100, false);
                        if (pair != null) {
                            BlockPos pos = (BlockPos)pair.getFirst();
                            BlockPos safePos = LevelHelper.getSafePos(pos, level);
                            PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                            PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                        } else {
                            PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.structure.not_in_area", (Object[])new Object[]{this.name}));
                        }
                    } else {
                        PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.structure.unknown", (Object[])new Object[]{this.name}));
                    }
                }
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.structure.disabled"));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

