/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBManageWaypointsPacket(String waypoint, boolean remove) implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBManageWaypointsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SBManageWaypointsPacket::waypoint, (StreamCodec)ByteBufCodecs.BOOL, SBManageWaypointsPacket::remove, SBManageWaypointsPacket::new);
    public static final CustomPacketPayload.Type<SBManageWaypointsPacket> ID = new CustomPacketPayload.Type(PGHelper.id("manage_waypoint"));

    @Override
    public void handle(ServerPlayer player) {
        InteractionHand hand = PGHelper.getPortalGunHand((Player)player);
        ItemStack stack = player.getItemInHand(hand);
        Waypoint wp = Waypoint.getWaypoint(this.waypoint);
        if (stack.getItem() instanceof IWaypointStorage && wp != null) {
            if (!this.remove) {
                IWaypointStorage.addWaypoint(stack, wp);
            }
            if (this.remove) {
                IWaypointStorage.deleteWaypoint(stack, wp);
                PGHelper.sendSuccessMsg((Player)player, Component.translatable((String)"ricksportalgun.deleted", (Object[])new Object[]{wp.getName()}));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

