/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBSetDestinationPacket(BlockPos pos, String dim) implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBSetDestinationPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SBSetDestinationPacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, SBSetDestinationPacket::dim, SBSetDestinationPacket::new);
    public static final CustomPacketPayload.Type<SBSetDestinationPacket> ID = new CustomPacketPayload.Type(PGHelper.id("destination"));

    @Override
    public void handle(ServerPlayer player) {
        InteractionHand hand = PGHelper.getPortalGunHand((Player)player);
        ItemStack stack = player.getItemInHand(hand);
        if (!PGConfigHelper.getDisabledDimensions().contains(this.dim)) {
            PortalGunItem.setHopLocation(stack, ResourceLocation.parse((String)this.dim), this.pos);
        } else {
            PGHelper.sendFailMsg((Player)player, "error.ricksportalgun.dimension.disabled");
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

