/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.recipe;

import com.jdolphin.ricksportalgun.common.init.PGRecipeSerializers;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.recipe.WorkbenchRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PortalGunWorkbenchRecipe
implements Recipe<WorkbenchRecipeInput> {
    private final List<ItemStack> items;
    final ItemStack result;
    private PlacementInfo placementInfo;

    public PortalGunWorkbenchRecipe(List<ItemStack> itemStacks, ItemStack result) {
        this.items = itemStacks;
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStack> getInputs() {
        return this.items;
    }

    public boolean matches(WorkbenchRecipeInput input, Level level) {
        if (!level.isClientSide && input.ingredientCount() == this.items.size()) {
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack stack = input.getItem(i);
                ItemStack ingredient = this.items.get(i);
                if (stack.getCount() < ingredient.getCount()) {
                    return false;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)ingredient)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack assemble(WorkbenchRecipeInput workbenchRecipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<? extends Recipe<WorkbenchRecipeInput>> getSerializer() {
        return PGRecipeSerializers.WORKBENCH_SERIALIZER;
    }

    public RecipeType<? extends Recipe<WorkbenchRecipeInput>> getType() {
        return PGRecipeTypes.WORKBENCH_TYPE;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            ArrayList ingredientList = new ArrayList();
            this.items.forEach(stack -> ingredientList.add(Ingredient.of((ItemLike)stack.getItem())));
            this.placementInfo = PlacementInfo.create(ingredientList);
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<PortalGunWorkbenchRecipe> {
        private static final MapCodec<PortalGunWorkbenchRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.listOf(1, 4).fieldOf("ingredients").forGetter(recipe -> recipe.items), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, PortalGunWorkbenchRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PortalGunWorkbenchRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.items, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, PortalGunWorkbenchRecipe::new);

        public MapCodec<PortalGunWorkbenchRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PortalGunWorkbenchRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

