/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.common.blockentity.SubetherBarrierBlockEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;

public class LevelHelper {
    public static List<String> DIMENSIONS = new ArrayList<String>();
    public static List<String> CLIENT_DIMENSIONS = new ArrayList<String>();

    public static void addDimension(String dim) {
        if (!DIMENSIONS.contains(dim)) {
            DIMENSIONS.add(dim);
        }
    }

    public static void addDimensions(List<String> dims) {
        for (String s : dims) {
            LevelHelper.addDimension(s);
        }
    }

    public static boolean isBlenderDestination(String s) {
        return PGHelper.id("blender").toString().equals(s);
    }

    public static List<String> getDimensionsAsString(Iterable<ServerLevel> levels, List<String> list) {
        levels.forEach(world -> {
            ResourceLocation worldKey = world.dimension().location();
            String s = worldKey.toString();
            if (!s.isEmpty() && !list.contains(s)) {
                list.add(s);
            }
        });
        return list;
    }

    public static List<String> getDimensionsAsString(Iterable<ServerLevel> levels) {
        return LevelHelper.getDimensionsAsString(levels, new ArrayList<String>());
    }

    public static List<BlockEntity> getBlockEntitiesInChunks(ServerLevel level, ChunkPos pos, int radius) {
        if (level != null) {
            ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    list.addAll(level.getChunk(pos.x + x, pos.z + z).getBlockEntities().values());
                }
            }
            return list;
        }
        return List.of();
    }

    public static boolean canPortalTo(ServerLevel level, BlockPos pos, ItemStack stack) {
        if (level != null) {
            String code = "";
            if (stack != null) {
                code = (String)stack.getOrDefault(PGDataComponents.CODE, (Object)"");
            }
            List<BlockEntity> blockEntities = LevelHelper.getBlockEntitiesInChunks(level, new ChunkPos(pos), 3);
            for (BlockEntity be : blockEntities) {
                if (!(be instanceof SubetherBarrierBlockEntity)) continue;
                SubetherBarrierBlockEntity barrier = (SubetherBarrierBlockEntity)be;
                return !barrier.canBlockPortal((Level)level, barrier.getBlockPos(), code);
            }
            return true;
        }
        return false;
    }

    public static ResourceKey<Level> getWorldKey(ResourceLocation dimension) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension);
    }

    public static ServerLevel getServerWorld(Level level, ResourceKey<Level> dimension) {
        return level.getServer().getLevel(dimension);
    }

    public static ResourceLocation getPlayerDimensionLocation(Player player) {
        return LevelHelper.getLevelDimensionLocation(player.level());
    }

    public static BlockPos getRandomCoord(ServerLevel level, int radius) {
        WorldBorder border = level.getWorldBorder();
        RandomSource rand = level.getRandom();
        int min = radius < 1000 ? 10 : 100;
        int xCoord = rand.nextInt(min, radius);
        int yCoord = Mth.nextInt((RandomSource)rand, (int)(level.getMinY() + 1), (int)level.getMaxY());
        int zCoord = rand.nextInt(min, radius);
        BlockPos posNew = new BlockPos(xCoord, yCoord, zCoord);
        return border.clampToBounds(posNew);
    }

    public static ServerLevel getRandomServerLevel(MinecraftServer server) {
        Iterable worlds = server.getAllLevels();
        ArrayList worldList = new ArrayList();
        worlds.forEach(world -> {
            if (world != null) {
                worldList.add(world);
            }
        });
        return (ServerLevel)worldList.get(PGConstants.RANDOM.nextInt(worldList.size()));
    }

    public static void randomTP(ServerPlayer player, int radius, boolean interdimensional) {
        ServerLevel level = player.serverLevel();
        ServerLevel dest = LevelHelper.getRandomServerLevel(player.server);
        LevelHelper.teleportEntity((Entity)player, interdimensional ? dest : level, LevelHelper.randomTeleport((Level)level, LevelHelper.getRandomCoord(dest, radius)));
    }

    public static BlockPos randomTeleport(Level level, BlockPos pos) {
        BlockPos blockpos;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double d3 = y;
        BlockPos result = blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean flag1 = false;
        while (!flag1 && blockpos.getY() > level.getMinY()) {
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = level.getBlockState(blockpos1);
            if (blockstate.blocksMotion()) {
                flag1 = true;
                continue;
            }
            d3 -= 1.0;
            blockpos = blockpos1;
        }
        if (flag1) {
            result = BlockPos.containing((double)x, (double)d3, (double)z);
        }
        return result;
    }

    public static BlockPos getSafePos(BlockPos bPos, ServerLevel level) {
        return LevelHelper.randomTeleport((Level)level, bPos);
    }

    private static BlockPos getSafePos(BlockPos bPos, ServerLevel level, int iteration) {
        BlockPos pos1;
        int y;
        int direction;
        ++iteration;
        ChunkAccess chunk = level.getChunk(bPos);
        level.setChunkForced(chunk.getPos().x, chunk.getPos().z, true);
        int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, bPos.getX(), bPos.getZ());
        int worldCenter = (level.getMinY() + 2 + height) / 2;
        int n = direction = y > worldCenter ? -1 : 1;
        for (y = bPos.getY(); y >= level.getMinY() + 2 && y <= level.getMaxY() && !LevelHelper.isRandomizerSafe((Level)level, pos1 = new BlockPos(bPos.getX(), y, bPos.getZ())); y += direction) {
        }
        if (!LevelHelper.isRandomizerSafe((Level)level, bPos = new BlockPos(bPos.getX(), y, bPos.getZ())) || y <= level.getMinY() + 2 || y >= level.getMaxY()) {
            return iteration <= 100 ? LevelHelper.getSafePos(LevelHelper.getRandomCoord(level, 25), level, iteration) : bPos;
        }
        level.setChunkForced(chunk.getPos().x, chunk.getPos().z, false);
        return bPos;
    }

    public static boolean endHasDragons(ServerLevel level) {
        EndDragonFight fight;
        if (level != null && Level.END.location().equals((Object)LevelHelper.getLevelDimensionLocation((Level)level)) && (fight = level.getDragonFight()) != null) {
            EndDragonFight.Data data = fight.saveData();
            return !data.dragonKilled() || data.isRespawning();
        }
        return false;
    }

    public static boolean isRandomizerSafe(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        BlockState aboveState = level.getBlockState(pos.above());
        BlockState belowState = level.getBlockState(pos.below());
        if (!(belowState.isSuffocating((BlockGetter)level, pos) || belowState.is(Blocks.LAVA) || belowState.isAir() || belowState.is(Blocks.KELP_PLANT) || state.isSuffocating((BlockGetter)level, pos) || state.is(Blocks.WATER) || state.is(Blocks.LAVA) || state.is(Blocks.KELP_PLANT))) {
            return !aboveState.isSuffocating((BlockGetter)level, pos) && !aboveState.is(Blocks.WATER) && !aboveState.is(Blocks.LAVA) && !aboveState.is(Blocks.KELP_PLANT);
        }
        return false;
    }

    public static void teleportEntity(Entity entity, ServerLevel level, BlockPos pos) {
        HashSet<Relative> relativeSet = new HashSet<Relative>();
        relativeSet.add(Relative.Y_ROT);
        entity.teleportTo(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), relativeSet, entity.getYRot(), entity.getXRot(), false);
    }

    public static ResourceLocation getLevelDimensionLocation(Level world) {
        return world.dimension().location();
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category) {
        world.playSound(null, pos, sound, category, 100.0f, 1.0f);
    }
}

