/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.render;

import com.jdolphin.ricksportalgun.client.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.client.render.state.PortalEntityRenderState;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class PortalEntityRenderer
extends class_897<PortalEntity, PortalEntityRenderState> {
    public static final class_2960 PORTAL_TEXTURE = PGHelper.id("textures/entity/portal.png");
    public PortalEntityModel model;
    private static int textureFrame = 0;
    private static final int frames = 8;
    private final List<String> names = List.of(new String[]{"_jeb", "rainbow", "rgb", "colourful", "colorful"});
    private static int tickTimer = 0;

    public PortalEntityRenderer(class_5617.class_5618 pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.method_32167(PortalEntityModel.LAYER_LOCATION));
    }

    @NotNull
    public PortalEntityRenderState createRenderState() {
        return new PortalEntityRenderState();
    }

    public class_2960 getPortalTexture(int i) {
        return PGHelper.id("textures/entity/portal_" + i + ".png");
    }

    public void extractRenderState(PortalEntity portal, PortalEntityRenderState state, float pPartialTick) {
        super.method_62354((class_1297)portal, (class_10017)state, pPartialTick);
        state.rgb = portal.getColor();
        state.yRot = portal.method_36454();
        state.isNew = !portal.exists();
        state.closing = (double)portal.field_6012 > (double)portal.getLifetime() * 0.9;
        state.opening = (double)portal.field_6012 < (double)portal.getLifetime() * 0.1;
        state.direction = portal.getPortalDirection();
        state.facing = portal.getPortalFacing();
        state.width = portal.getSize();
        state.name = portal.method_5477();
    }

    protected void openAnimation(PortalEntityRenderState state, class_4587 stack) {
        float f;
        if (state.isNew && state.opening) {
            f = class_3532.method_16439((float)(state.field_53328 / 20.0f), (float)0.0f, (float)1.0f);
            f = class_3532.method_15363((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.method_22905(f, f, f);
        }
        if (state.closing) {
            f = class_3532.method_16439((float)(state.field_53328 / 20.0f), (float)1.0f, (float)0.0f);
            f = class_3532.method_15363((float)f, (float)1.0f, (float)0.0f);
            f *= f;
            f *= f;
            stack.method_22905(f, f, f);
        }
    }

    public void render(@NotNull PortalEntityRenderState state, class_4587 stack, class_4597 source, int pPackedLight) {
        stack.method_22903();
        this.openAnimation(state, stack);
        class_2350 direction = state.direction;
        class_2350 facing = state.facing;
        stack.method_46416(0.0f, -1.0f, 0.0f);
        if (direction != null) {
            float height;
            class_2350.class_2351 axis = facing.method_10166();
            float zRot = 0.0f;
            float yRot = 0.0f;
            float xRot = 0.0f;
            float f = height = state.width > 2.0f ? state.width / 2.0f : 1.0f;
            if (direction.method_10166().method_10178()) {
                if (axis.equals((Object)class_2350.class_2351.field_11051)) {
                    stack.method_22905(state.width, 1.0f, height);
                    zRot = 180.0f;
                    yRot = 180.0f;
                    xRot = 90.0f;
                    stack.method_22904(0.0, 1.1, -1.0);
                }
                if (axis.equals((Object)class_2350.class_2351.field_11048)) {
                    stack.method_22905(height, 1.0f, state.width);
                    xRot = 0.0f;
                    yRot = 270.0f;
                    zRot = 90.0f;
                    stack.method_22904(-1.0, 1.1, 0.0);
                }
            } else {
                stack.method_22905(state.width, height, state.width);
            }
            stack.method_22907(class_7833.field_40713.rotationDegrees(xRot));
            stack.method_22907(class_7833.field_40717.rotationDegrees(zRot));
            stack.method_22907(class_7833.field_40715.rotationDegrees(direction.method_10166().method_10178() ? yRot : state.yRot));
        }
        class_4588 consumer = source.getBuffer(class_1921.method_23580((class_2960)this.getPortalTexture(textureFrame)));
        int i = state.rgb;
        if (state.name != null && this.names.contains(state.name.getString().toLowerCase())) {
            int k = class_3532.method_15375((float)state.field_53328);
            int l = k / 25;
            int i1 = class_1767.values().length;
            int j1 = l % i1;
            int k1 = (l + 1) % i1;
            float f = ((float)(k % 25) + class_3532.method_22450((float)state.field_53328)) / 25.0f;
            int l1 = class_1472.method_6634((class_1767)class_1767.method_7791((int)j1));
            int i2 = class_1472.method_6634((class_1767)class_1767.method_7791((int)k1));
            i = class_9848.method_61319((float)f, (int)l1, (int)i2);
        }
        this.model.method_62100(stack, consumer, 0xF000F0, class_4608.field_21444, i);
        stack.method_22909();
        super.method_3936((class_10017)state, stack, source, pPackedLight);
    }

    public static void tickTexture() {
        if (++tickTimer >= 4) {
            tickTimer = 0;
            textureFrame = (textureFrame + 1) % 8;
        }
    }
}

