/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGCycleButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBLocatePacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class LocatorScreen
extends AbstractBaseScreen {
    private SuggestionTextFieldWidget input;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGCycleButton<LocatorType> locatorType;
    private final List<String> playerList;
    private final List<String> biomeList;
    private final List<String> structureList;
    private PGImageButton backButton;

    public LocatorScreen(List<String> playerList, List<String> biomeList, List<String> structureList) {
        super("menu.ricksportalgun.player_locator");
        this.playerList = playerList;
        this.biomeList = biomeList;
        this.structureList = structureList;
    }

    private List<String> getListFromType(LocatorType type) {
        switch (type.ordinal()) {
            case 2: {
                return this.structureList;
            }
            case 1: {
                return this.playerList;
            }
        }
        return this.biomeList;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Optional optional = this.method_19355(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.input.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private LocatorType[] getAllowedLocators() {
        class_1799 stack = this.getItemStack();
        boolean canPlayerLocate = (Boolean)stack.method_57825(PGDataComponents.PLAYER_LOC, (Object)false);
        boolean canStructureLocate = (Boolean)stack.method_57825(PGDataComponents.STRUCTURE_LOC, (Object)false);
        if (canPlayerLocate && canStructureLocate) {
            return LocatorType.values();
        }
        if (!canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME};
        }
        if (canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME, LocatorType.PLAYER};
        }
        return new LocatorType[0];
    }

    protected void method_25426() {
        this.locatorType = (PGCycleButton)this.method_37063((class_364)PGCycleButton.builder(LocatorType::getDisplayName).withValues((LocatorType[])this.getAllowedLocators()).create(this.field_22789 / 2 - 64, this.field_22790 / 2 - 64, 128, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.locator"), (button, type) -> {
            List<String> list = this.getListFromType((LocatorType)((Object)type));
            this.input.setSuggestions(list);
        }));
        this.input = (SuggestionTextFieldWidget)this.method_25429((class_364)new SuggestionTextFieldWidget(this.field_22789 / 2 - 64, this.field_22790 / 2 - 32, 128, 24, class_2561.method_43471((String)"chat.editBox"), this.getListFromType(this.locatorType.getValue())));
        this.method_37063((class_364)this.input.getSuggestionList());
        this.select = (PGTextButton)this.method_37063((class_364)new PGTextButton(this.field_22789 / 2 - 136, this.field_22790 / 2 + 64, 128, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.select"), button -> {
            this.setCoords();
            this.method_25419();
        }, this.field_22793));
        this.backButton = (PGImageButton)this.method_37063((class_364)new PGImageButton(this.field_22789 / 2 - 140, this.field_22790 / 2 - 96, 20, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.back"), button -> {
            SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
            PGHelper.sendPacketToServer(packet);
        }, 20, 20, BACK_BUTTON_TEXTURE));
        this.cancel = (PGTextButton)this.method_37063((class_364)new PGTextButton(this.field_22789 / 2 + 8, this.field_22790 / 2 + 64, 128, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.cancel"), button -> this.method_25419(), this.field_22793));
        PortalGunStyle style = this.getStyle();
        this.input.method_1880(256);
        this.input.method_1858(true);
        this.input.method_1863(s -> this.input.update());
        this.locatorType.setRenderBackground(false);
        this.locatorType.setTextColor(style.textColor());
        this.locatorType.setRenderArrows(true);
        this.input.getSuggestionList().setBorderColor(style.highlightColor());
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((class_339)this.backButton, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.back"));
    }

    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        this.fillBackgroundColor(graphics);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"menu.ricksportalgun.locator"), this.field_22789 / 2, this.field_22790 / 2 - 92, style.textColor());
        if (this.input != null) {
            this.input.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        GuiHelper.renderOutline(graphics, (class_339)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (class_339)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, this.locatorType, style.highlightColor());
        GuiHelper.renderOutline(graphics, (class_339)this.input, style.highlightColor());
        GuiHelper.renderOutline(graphics, (class_339)this.backButton, style.highlightColor());
        class_2583 guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.method_10969() != null) {
            this.method_47413(graphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawOverlay(graphics);
        super.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void setCoords() {
        SBLocatePacket packet = new SBLocatePacket(this.input.method_1882(), this.locatorType.getValue().ordinal());
        PGHelper.sendPacketToServer(packet);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.method_25399() instanceof class_4185) {
                    return super.method_25404(pKeyCode, pScanCode, pModifiers);
                }
                this.setCoords();
            }
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public static enum LocatorType {
        BIOME("biome"),
        PLAYER("player"),
        STRUCTURE("structure");

        final String key;

        private LocatorType(String key) {
            this.key = key;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("ricksportalgun.button.locator." + this.key));
        }
    }
}

