/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import net.minecraft.class_8132;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PGScrollableWidget<E extends Entry<E>>
extends class_9017 {
    private static final class_2960 MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
    private static final class_2960 INWORLD_MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    protected final class_310 minecraft;
    protected final int itemHeight;
    private final TrackedList children = new TrackedList();
    protected boolean centerListVertically = true;
    protected int headerHeight;
    @Nullable
    private E selected;
    @Nullable
    private E hovered;
    private boolean renderScrollbar = true;

    public PGScrollableWidget(class_310 minecraft, int width, int height, int x, int y, int itemHeight) {
        super(x, y, width, height, class_5244.field_39003);
        this.minecraft = minecraft;
        this.itemHeight = itemHeight;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelectedIndex(int selected) {
        if (selected == -1) {
            this.setSelected(null);
        } else if (this.getItemCount() != 0) {
            this.setSelected(this.getEntry(selected));
        }
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
    }

    public E getFirstElement() {
        return (E)((Entry)this.children.getFirst());
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    @NotNull
    public final List<E> method_25396() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    public void replaceEntries(Collection<E> entries) {
        this.clearEntries();
        this.children.addAll(entries);
    }

    protected E getEntry(int index) {
        return (E)((Entry)this.method_25396().get(index));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected void addEntryToTop(E entry) {
        this.children.addFirst(entry);
    }

    protected boolean removeEntryFromTop(E entry) {
        double d0 = (double)this.method_44390() - this.method_44387();
        boolean flag = this.removeEntry(entry);
        this.method_44382((double)this.method_44390() - d0);
        return flag;
    }

    protected int getItemCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.method_25396().get(index));
    }

    @Nullable
    public final E getEntryAtPosition(double mouseX, double mouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.method_46426() + this.field_22758 / 2;
        int k = j - i;
        int l = j + i;
        int i1 = class_3532.method_15357((double)(mouseY - (double)this.method_46427())) - this.headerHeight + (int)this.method_44387() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(mouseX >= (double)k && mouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.method_25396().get(j1) : null);
    }

    public void updateSize(int width, class_8132 layout) {
        this.updateSizeAndPosition(width, layout.method_57727(), layout.method_48998());
    }

    public void updateSizeAndPosition(int width, int height, int y) {
        this.method_55445(width, height);
        this.method_48229(0, y);
        this.method_65506();
    }

    protected int method_44395() {
        return this.getItemCount() * this.itemHeight + this.headerHeight + 4;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.enableScissor(graphics);
        this.renderListBackground(graphics);
        this.renderListSeparators(graphics);
        this.renderListItems(graphics, mouseX, mouseY, delta);
        graphics.method_44380();
        this.method_44396(graphics);
    }

    protected void method_44396(class_332 guiGraphics) {
        if (this.renderScrollbar) {
            super.method_44396(guiGraphics);
        }
    }

    public void setRenderScrollbar(boolean renderScrollbar) {
        this.renderScrollbar = renderScrollbar;
    }

    protected void renderListSeparators(class_332 guiGraphics) {
        class_2960 resourcelocation = this.minecraft.field_1687 == null ? class_437.field_49895 : class_437.field_49897;
        class_2960 resourcelocation1 = this.minecraft.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
        guiGraphics.method_25290(class_1921::method_62277, resourcelocation, this.method_46426(), this.method_46427() - 2, 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
        guiGraphics.method_25290(class_1921::method_62277, resourcelocation1, this.method_46426(), this.method_55443(), 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
    }

    protected void renderListBackground(class_332 guiGraphics) {
        class_2960 resourcelocation = this.minecraft.field_1687 == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
        guiGraphics.method_25290(class_1921::method_62277, resourcelocation, this.method_46426(), this.method_46427(), (float)this.method_46426(), (float)(this.method_55443() + (int)this.method_44387()), this.method_25368(), this.method_25364(), 32, 32);
    }

    protected void enableScissor(class_332 guiGraphics) {
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
    }

    protected void centerScrollOn(E entry) {
        this.method_44382(this.method_25396().indexOf(entry) * this.itemHeight + this.itemHeight / 2 - this.field_22759 / 2);
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.method_25396().indexOf(entry));
        int j = i - this.method_46427() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.method_55443() - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int scroll) {
        this.method_44382(this.method_44387() + (double)scroll);
    }

    protected double method_44393() {
        return (double)this.itemHeight / 2.0;
    }

    protected int method_65507() {
        return this.getRowRight() + 6 + 2;
    }

    @NotNull
    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        return Optional.ofNullable(this.getEntryAtPosition(mouseX, mouseY));
    }

    public void method_25395(@Nullable class_364 listener) {
        E e = this.getFocused();
        if (e != listener && e instanceof class_4069) {
            class_4069 containereventhandler = (class_4069)e;
            containereventhandler.method_25395(null);
        }
        super.method_25395(listener);
        int i = this.children.indexOf(listener);
        if (i >= 0) {
            Object e1 = this.children.get(i);
            this.setSelected(e1);
            if (this.minecraft.method_48186().method_48183()) {
                this.ensureVisible(e1);
            }
        }
    }

    @Nullable
    protected E nextEntry(class_8028 direction) {
        return (E)this.nextEntry(direction, p_93510_ -> true);
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate) {
        return this.nextEntry(direction, predicate, this.getSelected());
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate, @Nullable E selected) {
        int i;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case field_41829: 
            case field_41828: {
                int n = 0;
                break;
            }
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = i = 1;
            }
        }
        if (!this.method_25396().isEmpty() && i != 0) {
            int j = selected == null ? (i > 0 ? 0 : this.method_25396().size() - 1) : this.method_25396().indexOf(selected) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry e = (Entry)this.method_25396().get(k);
                if (!predicate.test(e)) continue;
                return (E)e;
            }
        }
        return null;
    }

    protected void renderListItems(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getItemCount();
        for (int i1 = 0; i1 < l; ++i1) {
            int j1 = this.getRowTop(i1);
            int k1 = this.getRowBottom(i1);
            if (k1 < this.method_46427() || j1 > this.method_55443()) continue;
            this.renderItem(guiGraphics, mouseX, mouseY, partialTick, i1, i, j1, j, k);
        }
    }

    protected void renderItem(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        E e = this.getEntry(index);
        ((Entry)e).renderBack(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.hovered, e), partialTick);
        if (this.isSelectedItem(index)) {
            int i = this.method_25370() ? -1 : -8355712;
            this.renderSelection(guiGraphics, top, width, height, i, -16777216);
        }
        ((Entry)e).render(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.hovered, e), partialTick);
    }

    protected void renderSelection(class_332 guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.method_46426() + (this.field_22758 - width) / 2;
        int j = this.method_46426() + (this.field_22758 + width) / 2;
        guiGraphics.method_25294(i, top - 2, j, top + height + 2, outerColor);
        guiGraphics.method_25294(i + 1, top - 1, j - 1, top + height + 1, innerColor);
    }

    public int getRowLeft() {
        return this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    public int getRowTop(int index) {
        return this.method_46427() + 4 - (int)this.method_44387() + index * this.itemHeight + this.headerHeight;
    }

    public int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public int getRowWidth() {
        return 220;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    @Nullable
    protected E remove(int index) {
        Object e = this.children.get(index);
        return (E)(this.removeEntry(this.children.get(index)) ? e : null);
    }

    protected boolean removeEntry(E entry) {
        boolean flag = this.children.remove(entry);
        if (flag && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> entry) {
        entry.list = this;
    }

    protected void narrateListElementPosition(class_6382 narrationElementOutput, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int index) {
            return (Entry)this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int index, E entry) {
            Entry e = (Entry)this.delegate.set(index, entry);
            PGScrollableWidget.this.bindEntryToSelf(entry);
            return e;
        }

        @Override
        public void add(int index, E entry) {
            this.delegate.add(index, entry);
            PGScrollableWidget.this.bindEntryToSelf(entry);
        }

        @Override
        public E remove(int index) {
            return (Entry)this.delegate.remove(index);
        }
    }

    protected static abstract class Entry<E extends Entry<E>>
    implements class_364 {
        @Deprecated
        protected PGScrollableWidget<E> list;

        protected Entry() {
        }

        public void method_25365(boolean p_265302_) {
        }

        public boolean method_25370() {
            return this.list.getFocused() == this;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderBack(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals(this.list.getEntryAtPosition(mouseX, mouseY), this);
        }
    }
}

