/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.client.screen.widget.PGScrollableWidget;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class SuggestionTextFieldWidget
extends class_342 {
    private List<String> suggestions;
    private final SuggestionList suggestionListWidget;

    public SuggestionTextFieldWidget(int x, int y, int width, int height, class_5250 text, List<String> suggestions) {
        super(class_310.method_1551().field_1772, x, y, width, height, (class_2561)text);
        this.suggestions = suggestions;
        int i = Math.min(suggestions.size(), 3);
        this.suggestionListWidget = new SuggestionList(class_310.method_1551(), width, height * i, x, y + height, 14, this);
    }

    public SuggestionList getSuggestionList() {
        return this.suggestionListWidget;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> suggestions) {
        this.suggestions = suggestions;
        this.update();
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!this.method_25370()) {
            this.suggestionListWidget.field_22764 = false;
            this.suggestionListWidget.field_22763 = false;
        } else {
            this.suggestionListWidget.field_22764 = true;
            this.suggestionListWidget.field_22763 = true;
            this.suggestionListWidget.method_25394(graphics, mouseX, mouseY, delta);
        }
        super.method_48579(graphics, mouseX, mouseY, delta);
    }

    public void update() {
        List<String> suggestions = this.sortSuggestions(this.suggestions);
        this.suggestionListWidget.setSuggestions(suggestions);
        this.suggestionListWidget.method_44382(0.0);
        this.suggestionListWidget.method_53533(this.field_22759 * Math.min(3, suggestions.size()));
    }

    private List<String> sortSuggestions(List<String> suggestions) {
        String string = this.method_1882().substring(0, this.method_1881());
        int i = SuggestionTextFieldWidget.getStartOfCurrentWord(string);
        String string2 = string.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (String suggestion : suggestions) {
            String s = suggestion.substring(suggestion.indexOf(":") + 1);
            if (s.startsWith(string2)) {
                list.add(suggestion);
            }
            if (!suggestion.startsWith(string2)) {
                list2.add(suggestion);
                continue;
            }
            if (list.contains(suggestion)) continue;
            list.add(suggestion);
        }
        list.addAll(list2);
        return list;
    }

    private static int getStartOfCurrentWord(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = Pattern.compile("(\\s+)").matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    public static class SuggestionList
    extends PGScrollableWidget<SuggestionEntry> {
        private final SuggestionTextFieldWidget widget;
        private int borderColor = Color.WHITE.getRGB();

        public SuggestionList(class_310 minecraft, int width, int height, int x, int y, int itemHeight, SuggestionTextFieldWidget widget) {
            super(minecraft, width, height, x, y, itemHeight);
            this.widget = widget;
            List<String> suggestions = widget.suggestions;
            this.setSuggestions(suggestions);
        }

        public void setSuggestions(List<String> suggestions) {
            this.clearEntries();
            for (String s : suggestions) {
                if (s != null && !s.isEmpty()) {
                    SuggestionEntry entry = new SuggestionEntry(s, this);
                    if (this.method_25396().contains(entry)) continue;
                    this.addEntry(entry);
                    continue;
                }
                LogManager.getLogger().warn("Failed to get suggestion: {}", (Object)s);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.field_22763 && this.field_22764) {
                SuggestionEntry hoveredEntry;
                SuggestionEntry suggestionEntry = hoveredEntry = this.method_25405(mouseX, mouseY) ? (SuggestionEntry)this.getEntryAtPosition(mouseX, mouseY) : null;
                if (hoveredEntry == null) {
                    this.widget.method_25365(false);
                }
                return super.method_25402(mouseX, mouseY, button);
            }
            return false;
        }

        @Override
        protected void method_47399(@NotNull class_6382 output) {
            output.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.selection.usage"));
        }

        public void setBorderColor(int color) {
            this.borderColor = color;
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int x1 = this.method_46426();
            int y1 = this.method_46427();
            int x2 = this.method_55442();
            int y2 = this.method_55443();
            graphics.method_44379(x1, y1, x2, y2);
            graphics.method_25294(x1, y1, x2, y2, -805306368);
            graphics.method_44380();
            graphics.method_49601(x1, y1, this.method_25368(), this.method_25364(), this.borderColor);
            super.method_48579(graphics, mouseX, mouseY, delta);
        }

        @Override
        public int getRowWidth() {
            return this.field_22758 - 10;
        }

        @Override
        public int getRowRight() {
            return super.getRowRight() - 6;
        }

        public static class SuggestionEntry
        extends PGScrollableWidget.Entry<SuggestionEntry> {
            private final String string;
            private final PGTextButton button;
            protected SuggestionList list;
            private final SuggestionTextFieldWidget widget;

            SuggestionEntry(String suggestion, SuggestionList list) {
                this.string = suggestion;
                this.list = list;
                this.widget = list.widget;
                this.button = new PGTextButton(0, 0, this.list.field_22758 - 6, list.itemHeight, (class_2561)class_2561.method_43470((String)suggestion), pButton -> {
                    this.widget.method_1852(suggestion);
                    this.widget.method_25365(false);
                }, class_310.method_1551().field_1772);
            }

            @Override
            public void render(@NotNull class_332 context, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                SuggestionList wpList = this.list;
                if (top > wpList.headerHeight) {
                    this.button.method_46421(wpList.method_46426() + 2);
                    this.button.method_46419(top);
                    this.button.method_25355((class_2561)class_2561.method_43470((String)this.string));
                    this.button.method_25394(context, mouseX, mouseY, tickDelta);
                }
            }

            public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
                return this.button.method_25402(pMouseX, pMouseY, pButton);
            }

            public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
                return this.button.method_25406(pMouseX, pMouseY, pButton);
            }
        }
    }
}

