/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointInfoScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGScrollableWidget;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class WaypointListWidget
extends PGScrollableWidget<WaypointEntry> {
    public static class_2960 WAYPOINT_INFO_TEXTURES = PGHelper.id("textures/gui/sprites/icon/waypoint_info.png");
    public boolean showInfoButton;
    public int rowWidth = 188;
    private final int buttonWidth;
    private final int buttonHeight;
    private boolean renderButtonBg = true;
    protected class_4185.class_4241 onPress;
    private PortalGunStyle style = PortalGunStyle.DEFAULT;

    public WaypointListWidget(int width, int height, int x, int y, int itemHeight, class_1799 stack, boolean showInfo, int buttonWidth, int buttonHeight) {
        super(class_310.method_1551(), width, height, x, y, itemHeight);
        this.showInfoButton = showInfo;
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
        this.refreshEntries(stack);
    }

    public void setStyle(PortalGunStyle style) {
        this.style = style;
    }

    @Override
    protected void renderListBackground(class_332 guiGraphics) {
    }

    public void refreshEntries(class_1799 stack) {
        this.method_25396().clear();
        List<Waypoint> waypoints = IWaypointStorage.getWaypoints(stack);
        for (Waypoint waypoint : waypoints) {
            if (waypoint != null) {
                this.addEntryToTop(new WaypointEntry(waypoint, this, this.showInfoButton, this.renderButtonBg, this.style.highlightColor()));
                continue;
            }
            LogManager.getLogger().warn("Failed to get Waypoint");
        }
    }

    @Override
    public int getRowWidth() {
        return this.rowWidth;
    }

    public void setOnPress(class_4185.class_4241 onPress) {
        this.onPress = onPress;
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43473());
    }

    public void setRenderButtonBackground(boolean renderButtonBg) {
        this.renderButtonBg = renderButtonBg;
    }

    public static class WaypointEntry
    extends PGScrollableWidget.Entry<WaypointEntry> {
        private final class_4185 button;
        private final PGImageButton infoButton;
        protected WaypointListWidget list;
        private final boolean showInfo;
        private final int color;
        private final boolean renderBG;
        public final Waypoint waypoint;

        WaypointEntry(Waypoint waypoint, WaypointListWidget list, boolean showInfoButton, boolean renderButtonBG, int borderColor) {
            this.waypoint = waypoint;
            this.list = list;
            this.showInfo = showInfoButton;
            this.color = borderColor;
            this.renderBG = renderButtonBG;
            class_4185.class_4241 press = this.list.onPress;
            if (this.list.onPress == null) {
                press = pButton -> {
                    SBSetDestinationPacket packet = new SBSetDestinationPacket(waypoint.getBlockPos(), waypoint.getDimension());
                    PGHelper.sendPacketToServer(packet);
                    class_310.method_1551().method_1507(null);
                };
            }
            this.button = renderButtonBG ? class_4185.method_46430((class_2561)class_2561.method_43470((String)waypoint.getName()), (class_4185.class_4241)press).method_46433(16, 0).method_46437(list.buttonWidth, list.buttonHeight).method_46431() : new PGTextButton(16, 0, list.buttonWidth, list.buttonHeight, (class_2561)class_2561.method_43470((String)waypoint.getName()), press, class_310.method_1551().field_1772);
            this.infoButton = new PGImageButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.waypoint.info"), button -> class_310.method_1551().method_1507((class_437)new WaypointInfoScreen(waypoint)), 20, 20, WAYPOINT_INFO_TEXTURES);
            this.infoButton.setRenderBackground(renderButtonBG);
            this.infoButton.setColor(this.list.style.textColor());
            this.infoButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"ricksportalgun.button.waypoint.info")));
            class_4185 class_41852 = this.button;
            if (class_41852 instanceof PGTextButton) {
                PGTextButton textButton = (PGTextButton)class_41852;
                textButton.setTextColour(this.list.style.textColor());
            }
        }

        @Override
        public void render(@NotNull class_332 graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            WaypointListWidget wpList = this.list;
            if (pTop > wpList.headerHeight) {
                this.button.method_46421(pLeft + (this.showInfo ? 18 : 56));
                this.button.method_46419(pTop);
                this.button.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
                if (!this.renderBG) {
                    GuiHelper.renderOutline(graphics, (class_339)this.button, this.color);
                }
                if (this.showInfo) {
                    this.infoButton.method_46421(pLeft + this.button.method_25368() + 20);
                    this.infoButton.method_46419(pTop);
                    if (!this.renderBG) {
                        GuiHelper.renderOutline(graphics, (class_339)this.infoButton, this.color);
                    }
                    this.infoButton.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
                }
            }
        }

        public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
            if (this.button.method_25402(pMouseX, pMouseY, pButton)) {
                return true;
            }
            return this.infoButton.method_25402(pMouseX, pMouseY, pButton);
        }

        public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
            return this.button.method_25406(pMouseX, pMouseY, pButton) || this.infoButton.method_25406(pMouseX, pMouseY, pButton);
        }
    }
}

