/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.item.upgrade.AbstractUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class PortalGunItem
extends class_1792
implements IWaypointStorage {
    public PortalGunItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static int getMaxFuel(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.MAX_FUEL, (Object)64);
    }

    public static int getFuel(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.FUEL, (Object)64);
    }

    public static void lowerFuel(class_1799 stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        int j = PortalGunItem.getMaxFuel(stack) - i;
        int fuel = Math.max(0, i - amount);
        stack.method_57379(PGDataComponents.FUEL, (Object)fuel);
    }

    public static void setPrimaryDye(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.PRIMARY_DYE, (Object)color);
    }

    public static void setSecondaryDye(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.SECONDARY_DYE, (Object)color);
    }

    public static int getPrimaryDye(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PRIMARY_DYE, (Object)0);
    }

    public static int getSecondaryDye(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.SECONDARY_DYE, (Object)0);
    }

    public static void setCode(class_1799 stack, String code) {
        stack.method_57379(PGDataComponents.CODE, (Object)code);
    }

    public static String getCode(class_1799 stack) {
        return (String)stack.method_57825(PGDataComponents.CODE, (Object)"");
    }

    public static void refillFuel(class_1799 stack) {
        stack.method_57379(PGDataComponents.FUEL, (Object)PortalGunItem.getMaxFuel(stack));
    }

    public static void migrateDamage(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49629)) {
            int fuel = PortalGunItem.getMaxFuel(stack) - (Integer)stack.method_57825(class_9334.field_49629, (Object)0);
            stack.method_57379(PGDataComponents.FUEL, (Object)fuel);
            stack.method_57381(class_9334.field_49629);
        }
    }

    public static boolean refuel(class_1799 stack, class_1657 player) {
        class_1268 pgHand = PGHelper.getPortalGunHand(player);
        class_1268 fluidHand = PGHelper.getOppositeHand(pgHand);
        class_1799 gunStack = player.method_5998(pgHand);
        class_1799 fluidStack = player.method_5998(fluidHand);
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && gunStack.method_31573(PGTags.Items.PORTAL_GUNS)) {
            if (fluidStack.method_31574(PGItems.PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                fluidStack.method_7934(1);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)false);
                return true;
            }
            if (fluidStack.method_31574(PGItems.BOOTLEG_PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)true);
                fluidStack.method_7934(1);
                return true;
            }
        }
        return false;
    }

    public static void setPortalGunType(class_1799 stack, PortalGunType type) {
        stack.method_57379(PGDataComponents.PORTAL_GUN_TYPE, (Object)type);
        stack.method_57379(class_9334.field_54199, (Object)type.model());
        if (stack.method_65130() == null) {
            stack.method_57379(class_9334.field_50239, (Object)type.name());
        }
        PortalGunItem.setDefaultColor(stack, type.color());
    }

    public static PortalGunType getPortalGunType(class_1799 stack) {
        return (PortalGunType)stack.method_57825(PGDataComponents.PORTAL_GUN_TYPE, (Object)PortalGunType.DEFAULT);
    }

    private class_243 getLocation(class_1937 level, class_2338 bPos, class_2350 dir, class_243 loc) {
        if (this.isAir(level, bPos.method_10074()) && dir == class_2350.field_11033) {
            return loc.method_1031(0.0, -0.2, 0.0);
        }
        if (dir.equals((Object)class_2350.field_11036)) {
            return loc;
        }
        if (!this.isAir(level, bPos.method_10093(dir))) {
            switch (dir) {
                case field_11043: {
                    class_243 vec = bPos.method_10095().method_61082();
                    loc = vec.method_1031(0.0, 0.0, 0.4);
                    break;
                }
                case field_11035: {
                    class_243 vec = bPos.method_10072().method_61082();
                    loc = vec.method_1031(0.0, 0.0, -0.4);
                    break;
                }
                case field_11039: {
                    class_243 vec = bPos.method_10067().method_61082();
                    loc = vec.method_1031(0.4, 0.0, 0.0);
                    break;
                }
                case field_11034: {
                    class_243 vec = bPos.method_10078().method_61082();
                    loc = vec.method_1031(-0.4, 0.0, 0.0);
                }
            }
        } else {
            float x;
            float f = dir.method_10166().equals((Object)class_2350.class_2351.field_11048) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : (x = 0.0f);
            float z = dir.method_10166().equals((Object)class_2350.class_2351.field_11051) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : 0.0f;
            loc = new class_243(loc.method_10216() + (double)x, (double)bPos.method_10264(), loc.method_10215() + (double)z);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public class_1269 method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_2350 dir;
        class_1799 stack = player.method_5998(hand);
        class_1799 oppositeStack = player.method_5998(PGHelper.getOppositeHand(hand));
        class_3965 hitResult = PortalGunItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        if (level.method_8608()) return class_1269.field_5814;
        if (!(player instanceof class_3222)) return class_1269.field_5814;
        PortalGunItem.migrateDamage(stack);
        PortalGunItem.migrateNBT(stack);
        if (!PGHelper.canPlayerAccessGun(player, stack)) return class_1269.field_5812;
        class_1792 class_17922 = oppositeStack.method_7909();
        if (class_17922 instanceof AbstractUpgradeItem) {
            AbstractUpgradeItem upgrade = (AbstractUpgradeItem)class_17922;
            class_1269 result = upgrade.applyUpgrade(player, stack, this);
            if (player.method_7337()) return result;
            oppositeStack.method_7934(1);
            return result;
        }
        if (PortalGunItem.refuel(stack, player)) return class_1269.field_5812;
        if (PortalGunItem.getFuel(stack) <= 0) return class_1269.field_5812;
        class_243 loc = hitResult.method_17784();
        if (hitResult.method_17783().equals((Object)class_239.class_240.field_1332)) {
            dir = hitResult.method_17780();
            class_2338 bPos = hitResult.method_17777();
            loc = this.getLocation(level, bPos, dir, loc);
        }
        dir = hitResult.method_17780();
        class_2350 facing = player.method_5735();
        float size = ((Float)stack.method_57825(PGDataComponents.PORTAL_SIZE, (Object)Float.valueOf(1.0f))).floatValue();
        int age = (Integer)stack.method_57825(PGDataComponents.PORTAL_LIFETIME, (Object)10);
        PortalEntity portal = new PortalEntity(level, loc, dir, facing, size);
        PortalEntity exPortal = new PortalEntity(level, PortalGunItem.getHopCoords(stack).method_10084().method_61082(), dir, facing, size);
        class_5321<class_1937> key = LevelHelper.getWorldKey((class_2960)stack.method_57825(PGDataComponents.PORTAL_DIM, (Object)class_1937.field_25179.method_29177()));
        class_3218 serverlevel = LevelHelper.getServerWorld(level, key);
        this.doForBoth(entity -> entity.setLifetime(PGHelper.seconds(age)), portal, exPortal);
        class_2561 customName = stack.method_65130();
        if (customName != null) {
            this.doForBoth(entity -> entity.method_5665(customName), portal, exPortal);
        }
        portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
        exPortal.setHopLocation(level.method_27983().method_29177(), portal.method_24515());
        int color = PortalGunItem.getColor(stack);
        this.doForBoth(entity -> entity.setColor(color), portal, exPortal);
        boolean bootleg = (Boolean)stack.method_57825(PGDataComponents.BOOTLEG, (Object)false);
        this.doForBoth(entity -> entity.setBootleg(bootleg), portal, exPortal);
        if (LevelHelper.isBlenderDestination(PortalGunItem.getHopDimension(stack).toString())) {
            if (!portal.isFlat()) {
                portal.method_36456(player.method_36454());
            }
            level.method_8649((class_1297)portal);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_7357().method_62835(stack, 60);
            if (player.method_7337()) return class_1269.field_5812;
            PortalGunItem.lowerFuel(stack, 1);
            return class_1269.field_5812;
        }
        if (!LevelHelper.canPortalTo(serverlevel, PortalGunItem.getHopCoords(stack), stack)) {
            PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.dragon");
            return class_1269.field_5812;
        }
        if (PortalGunItem.canBypassDragon(stack) || !LevelHelper.endHasDragons((class_3218)level) && !LevelHelper.endHasDragons(serverlevel)) {
            if (!portal.isFlat()) {
                this.doForBoth(entity -> entity.method_36456(player.method_36454()), portal, exPortal);
            }
            serverlevel.method_8649((class_1297)exPortal);
            level.method_8649((class_1297)portal);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_7357().method_62835(stack, 60);
            if (player.method_7337()) return class_1269.field_5812;
            PortalGunItem.lowerFuel(stack, 1);
            return class_1269.field_5812;
        }
        PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.unreachable");
        return class_1269.field_5814;
    }

    private void doForBoth(Consumer<PortalEntity> consumer, PortalEntity a, PortalEntity b) {
        consumer.accept(a);
        consumer.accept(b);
    }

    public static boolean canBypassDragon(class_1799 stack) {
        return (Boolean)stack.method_57825(PGDataComponents.EXTRA_DIMENSIONS_2, (Object)false);
    }

    private boolean isAir(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26215();
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 pContext, List<class_2561> toolTips, @NotNull class_1836 pTooltipFlag) {
        List list = (List)stack.method_57825(PGDataComponents.WAYPOINTS, List.of());
        if (!class_437.method_25442()) {
            toolTips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(stack).method_10263(), PortalGunItem.getHopCoords(stack).method_10264(), PortalGunItem.getHopCoords(stack).method_10260()}).method_27692(class_124.field_1080));
            toolTips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).method_27692(class_124.field_1080));
            toolTips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.fuel", (Object[])new Object[]{PortalGunItem.getFuel(stack), PortalGunItem.getMaxFuel(stack)}).method_27692(class_124.field_1080));
        } else {
            toolTips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.waypoints", (Object[])new Object[]{list.size()}).method_27692(class_124.field_1080));
            if (stack.method_57826(PGDataComponents.PRIMARY_DYE) || stack.method_57826(PGDataComponents.SECONDARY_DYE)) {
                toolTips.add((class_2561)class_2561.method_43469((String)"item.dyed", (Object[])new Object[]{list.size()}).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}));
            }
        }
    }

    public int method_31571(@NotNull class_1799 stack) {
        return PortalGunItem.getColor(stack);
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public static int getColor(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PORTAL_COLOUR, (Object)Color.GREEN.getRGB());
    }

    public static void setDefaultColor(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)color);
    }

    public static void setStyle(class_1799 stack, PortalGunStyle style) {
        stack.method_57379(PGDataComponents.PORTAL_GUN_STYLE, (Object)style);
    }

    public static void setColor(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.PORTAL_COLOUR, (Object)color);
    }

    public static void setHopLocation(class_1799 stack, class_2960 dimension, class_2338 pos) {
        stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)dimension);
        stack.method_57379(PGDataComponents.PORTAL_POS, (Object)pos);
    }

    public static class_2960 getHopDimension(class_1799 stack) {
        return (class_2960)stack.method_57825(PGDataComponents.PORTAL_DIM, (Object)class_1937.field_25179.method_29177());
    }

    public static class_2338 getHopCoords(class_1799 stack) {
        return (class_2338)stack.method_57825(PGDataComponents.PORTAL_POS, (Object)class_2338.field_10980);
    }

    public static void migrateNBT(class_1799 stack) {
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
        if (data != null) {
            String dim = "PortalDimension";
            String fuel = "Fuel";
            String pos = "PortalPos";
            String bootleg = "Bootleg";
            String color = "Color";
            String waypoints = "Waypoints";
            String lock = "Lock";
            String owner = "Owner";
            String defaultColor = "DefaultColor";
            class_2487 tag = data.method_57463();
            if (tag.method_10545(dim)) {
                String dimension = tag.method_10558(dim);
                class_2960 rl = class_2960.method_60654((String)dimension);
                stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)rl);
                tag.method_10551(dim);
            }
            if (tag.method_10545(fuel)) {
                int f = tag.method_10550(fuel);
                stack.method_57379(PGDataComponents.FUEL, (Object)f);
                tag.method_10551(fuel);
            }
            if (tag.method_10545(pos)) {
                class_2338 blockPos = (class_2338)class_2512.method_10691((class_2487)tag, (String)pos).get();
                stack.method_57379(PGDataComponents.PORTAL_POS, (Object)blockPos);
                tag.method_10551(pos);
            }
            if (tag.method_10545(bootleg)) {
                boolean acid = tag.method_10577(bootleg);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)acid);
                tag.method_10551(bootleg);
            }
            if (tag.method_10545(color)) {
                int colour = tag.method_10550(color);
                stack.method_57379(PGDataComponents.PORTAL_COLOUR, (Object)colour);
                tag.method_10551(color);
            }
            if (tag.method_10545(waypoints)) {
                class_2499 listTag = tag.method_10554(waypoints, 8);
                List<Waypoint> waypointList = listTag.stream().map(class_2520::method_10714).map(Waypoint::getWaypoint).toList();
                stack.method_57379(PGDataComponents.WAYPOINTS, waypointList);
                tag.method_10551(waypoints);
            }
            if (tag.method_10545(lock)) {
                boolean locked = tag.method_10577(lock);
                stack.method_57379(PGDataComponents.LOCK, (Object)locked);
                tag.method_10551(lock);
            }
            if (tag.method_10545(owner)) {
                String own = tag.method_10558(owner);
                stack.method_57379(PGDataComponents.OWNER, (Object)own);
                tag.method_10551(owner);
            }
            if (tag.method_10545(defaultColor)) {
                int defColour = tag.method_10550(defaultColor);
                stack.method_57379(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)defColour);
                tag.method_10551(defaultColor);
            }
        }
    }
}

