/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun;

import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="ricksportalgun")
public class PortalGunMod {
    public static final String MODID = "ricksportalgun";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();

    public PortalGunMod(ModContainer container) {
        IEventBus bus = container.getEventBus();
        bus.addListener(this::buildContents);
        bus.addListener(this::registerPackets);
        PGItems.ITEMS.register(bus);
        PGEntities.ENTITIES.register(bus);
        PGSounds.register();
        PGDataComponents.COMPONENTS.register(bus);
        NeoForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PGCommonConfig.SPEC, "portalgun-common.toml");
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        PGPackets.init(registrar);
    }

    @SubscribeEvent
    public void brewingRecipeEvent(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.POISON)}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT}), ((Item)PGItems.QUANTUM_LEAP_ELIXIR.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.THICK)}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE}), ((Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PGItems.QUANTUM_LEAP_ELIXIR.get()}), ((Item)PGItems.PORTAL_FLUID_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PGItems.QUANTUM_LEAP_ELIXIR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get()}), ((Item)PGItems.PORTAL_FLUID_BOTTLE.get()).getDefaultInstance());
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept((ItemLike)PGItems.PORTAL_FLUID_BOTTLE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)PGItems.QUANTUM_LEAP_ELIXIR.get());
            event.accept((ItemLike)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.accept((ItemLike)PGItems.PORTAL_GUN.get());
            event.accept((ItemLike)PGItems.PRIME_PORTAL_GUN.get());
            event.accept((ItemLike)PGItems.GOLDEN_PORTAL_GUN.get());
        }
    }
}

