/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.client.renderer.PortalEntityRenderer;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.SBColourPacket;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.joml.Matrix4f;

public class ColourPickingScreen
extends AbstractBaseScreen {
    private ExtendedSlider r;
    private ExtendedSlider g;
    private ExtendedSlider b;

    protected ColourPickingScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.colour_select"));
    }

    protected void init() {
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = player.getMainHandItem();
        Color color = new Color((Integer)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_COLOUR.get(), (Object)Color.GREEN.getRGB()));
        this.r = (ExtendedSlider)this.addWidget((GuiEventListener)new ExtendedSlider(this.width / 2 - 44, this.height / 2 - 54, 36, 16, (Component)Component.empty(), (Component)Component.empty(), 0.0, 255.0, (double)color.getRed(), 1.0, 1, false));
        this.g = (ExtendedSlider)this.addWidget((GuiEventListener)new ExtendedSlider(this.width / 2 - 44, this.height / 2 - 36, 36, 16, (Component)Component.empty(), (Component)Component.empty(), 0.0, 255.0, (double)color.getGreen(), 1.0, 1, false));
        this.b = (ExtendedSlider)this.addWidget((GuiEventListener)new ExtendedSlider(this.width / 2 - 44, this.height / 2 - 18, 36, 16, (Component)Component.empty(), (Component)Component.empty(), 0.0, 255.0, (double)color.getBlue(), 1.0, 1, false));
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.colour.select"), button -> {
            if (stack.is(PGTags.Items.PORTAL_GUNS)) {
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGPackets.sendToServer(packet);
                this.onClose();
            }
        }).size(128, 20).pos(this.width / 2 - 136, this.height / 2 + 32).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose()).size(128, 20).pos(this.width / 2 + 8, this.height / 2 + 32).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.colour.reset"), button -> {
            Color colour = new Color((Integer)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_COLOUR.get(), (Object)(stack.is((Item)PGItems.GOLDEN_PORTAL_GUN.get()) ? Color.YELLOW.getRGB() : Color.GREEN.getRGB())));
            this.r.setValue((double)colour.getRed());
            this.g.setValue((double)colour.getGreen());
            this.b.setValue((double)colour.getBlue());
        }).pos(this.width / 2 + 72, this.height / 2 + 8).size(64, 20).build());
    }

    public int getColor() {
        try {
            return new Color(this.r.getValueInt(), this.g.getValueInt(), this.b.getValueInt()).getRGB();
        }
        catch (NumberFormatException e) {
            GuiHelper.drawWhiteCenteredString(new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource()), String.valueOf(Component.translatable((String)"notice.ricksportalgun.color.error")) + e.getMessage().toLowerCase(), this.width / 2, 55);
            return 0;
        }
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.colour_select.red"), this.width / 2 - 80, this.height / 2 - 48);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.colour_select.green"), this.width / 2 - 80, this.height / 2 - 32);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.colour_select.blue"), this.width / 2 - 80, this.height / 2 - 14);
        GuiHelper.drawWhiteCenteredString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.colour_select"), this.width / 2, 30);
        GuiHelper.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick, new AbstractWidget[]{this.r, this.g, this.b});
        this.renderPortalTexture(pPoseStack, 40.0f, this.getColor());
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void renderPortalTexture(GuiGraphics graphics, float pScale, int colour) {
        PoseStack stack = graphics.pose();
        stack.pushPose();
        stack.translate((float)this.width / 2.0f + 24.0f, (float)this.height / 2.0f - 64.0f, 0.0f);
        PortalEntityModel model = new PortalEntityModel(Minecraft.getInstance().getEntityModels().bakeLayer(PortalEntityModel.LAYER_LOCATION));
        stack.mulPose(new Matrix4f().scaling(pScale, pScale, pScale));
        model.renderToBuffer(stack, graphics.bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)PortalEntityRenderer.PORTAL_TEXTURE)), 0xF000F0, OverlayTexture.NO_OVERLAY, colour);
        graphics.flush();
        stack.popPose();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.getFocused() instanceof Button) {
                    return super.keyPressed(pKeyCode, pScanCode, pModifiers);
                }
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGPackets.sendToServer(packet);
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

