/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.gui.ColourPickingScreen;
import com.jdolphin.ricksportalgun.client.gui.PlayerLocatorScreen;
import com.jdolphin.ricksportalgun.client.gui.SettingsScreen;
import com.jdolphin.ricksportalgun.client.gui.WaypointScreen;
import com.jdolphin.ricksportalgun.client.gui.widget.BetterImageButton;
import com.jdolphin.ricksportalgun.client.gui.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.SBCoordCheckerPacket;
import com.jdolphin.ricksportalgun.common.packet.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CoordTravelScreen
extends AbstractBaseScreen {
    private BetterImageButton waypoints;
    private BetterImageButton randomise;
    private BetterImageButton player_loc;
    private BetterImageButton colour;
    private BetterImageButton settings;
    private String dS;
    private String xS;
    private String yS;
    private String zS;
    private EditBox xInput;
    private EditBox yInput;
    private EditBox zInput;
    private SuggestionTextFieldWidget dimInput;
    private final List<String> dims;
    private final boolean hideWaypoints;
    public static ResourceLocation WAYPOINT_TEXTURES = PGHelper.createLocation("icon/waypoint");
    public static ResourceLocation PLAYER_LOC_TEXTURES = PGHelper.createLocation("icon/player_locating");
    public static ResourceLocation RANDOMIZER_TEXTURES = PGHelper.createLocation("icon/randomizer");
    public static ResourceLocation COLOR_TEXTURES = PGHelper.createLocation("icon/color_selection");
    public static ResourceLocation SETTINGS_TEXTURES = PGHelper.createLocation("icon/settings");

    public CoordTravelScreen(List<String> dimensions, boolean hideWaypoints) {
        super((Component)Component.translatable((String)"menu.ricksportalgun.coord"));
        this.dims = dimensions;
        this.hideWaypoints = hideWaypoints;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isPresent() && ((GuiEventListener)optional.get()).equals((Object)this.dimInput.getSuggestionList())) {
            return this.dimInput.getSuggestionList().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void init() {
        super.init();
        this.dimInput = (SuggestionTextFieldWidget)this.addWidget((GuiEventListener)new SuggestionTextFieldWidget(this, this.width / 2 - 32, this.height / 2 - 32, 112, 12, Component.translatable((String)"chat.editBox"), this.dims));
        this.addWidget((GuiEventListener)this.dimInput.getSuggestionList());
        this.xInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 - 16, 64, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.yInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2, 64, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.zInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 + 16, 64, 12, (Component)Component.translatable((String)"chat.editBox")));
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.coord.select"), button -> {
            this.setCoords();
            this.onClose();
        }).pos(this.width / 2 - 136, this.height / 2 + 32).size(128, 20).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose()).size(128, 20).pos(this.width / 2 + 8, this.height / 2 + 32).build());
        if (!this.hideWaypoints) {
            this.waypoints = this.addRenderableWidget(new BetterImageButton(this.width / 2 - 90, this.height / 2 + 64, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.waypoint"), button -> this.minecraft.setScreen((Screen)new WaypointScreen()), 20, 18, WAYPOINT_TEXTURES));
        }
        this.player_loc = this.addRenderableWidget(new BetterImageButton(this.width / 2 - 64, this.height / 2 + 64, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.player_locator"), button -> this.minecraft.setScreen((Screen)new PlayerLocatorScreen()), 20, 18, PLAYER_LOC_TEXTURES));
        this.randomise = this.addRenderableWidget(new BetterImageButton(this.width / 2 - 38, this.height / 2 + 64, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.randomise"), button -> {
            LocalPlayer player = this.minecraft.player;
            ItemStack itemStack = player.getMainHandItem();
            if (itemStack.is(PGTags.Items.PORTAL_GUNS)) {
                Level level = player.level();
                String dim = this.dimInput.getValue().isEmpty() ? level.dimension().location().toString() : this.dimInput.getValue();
                PGPackets.sendToServer(new SBCoordCheckerPacket(dim));
                this.onClose();
            }
        }, 20, 18, RANDOMIZER_TEXTURES));
        this.colour = this.addRenderableWidget(new BetterImageButton(this.width / 2 - 12, this.height / 2 + 64, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.colour"), button -> this.minecraft.setScreen((Screen)new ColourPickingScreen()), 20, 18, COLOR_TEXTURES));
        this.settings = this.addRenderableWidget(new BetterImageButton(this.width / 2 + 14, this.height / 2 + 64, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.settings"), button -> this.minecraft.setScreen((Screen)new SettingsScreen()), 20, 18, SETTINGS_TEXTURES));
        this.dimInput.setMaxLength(256);
        this.dimInput.setBordered(true);
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            ResourceLocation location = player.level().dimension().location();
            this.dS = location.getNamespace().equals("minecraft") ? location.getPath() : location.toString();
            this.dimInput.setSuggestion(this.dS);
            this.xS = String.valueOf((int)player.getX());
            this.yS = String.valueOf((int)player.getY());
            this.zS = String.valueOf((int)player.getZ());
            this.xInput.setSuggestion(this.xS);
            this.yInput.setSuggestion(this.yS);
            this.zInput.setSuggestion(this.zS);
        }
        this.dimInput.setResponder(this::onEdited);
        this.xInput.setResponder(this::onEdited);
        this.yInput.setResponder(this::onEdited);
        this.zInput.setResponder(this::onEdited);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.dimInput.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tick() {
        super.tick();
        assert (this.minecraft != null);
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            if (!this.dimInput.isFocused() && this.dimInput.getValue().isEmpty()) {
                this.dimInput.setSuggestion(player.clientLevel.dimension().location().toString());
            } else {
                this.dimInput.setSuggestion("");
            }
        }
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.coord.x"), this.width / 2 - 88, this.height / 2 - 16);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.coord.y"), this.width / 2 - 88, this.height / 2);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.coord.z"), this.width / 2 - 88, this.height / 2 + 16);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.coord.dimension"), this.width / 2 - 88, this.height / 2 - 32);
        GuiHelper.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick, new AbstractWidget[]{this.dimInput, this.waypoints, this.xInput, this.yInput, this.zInput, this.randomise, this.player_loc, this.colour, this.settings});
        if (this.waypoints != null) {
            this.waypoints.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.waypoint")));
        }
        this.player_loc.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.player_locator")));
        this.randomise.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.randomise")));
        this.colour.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.colour")));
        this.settings.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.settings")));
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void onEdited(String string) {
        String xValue = this.xInput.getValue();
        String yValue = this.yInput.getValue();
        String zValue = this.zInput.getValue();
        this.dimInput.setSuggestion("");
        this.dimInput.update();
        if (this.xS.startsWith(this.xInput.getValue())) {
            this.xInput.setSuggestion(this.xS.substring(xValue.length()));
        } else {
            this.xInput.setSuggestion("");
        }
        if (this.yS.startsWith(this.yInput.getValue())) {
            this.yInput.setSuggestion(this.yS.substring(yValue.length()));
        } else {
            this.yInput.setSuggestion("");
        }
        if (this.zS.startsWith(this.zInput.getValue())) {
            this.zInput.setSuggestion(this.zS.substring(zValue.length()));
        } else {
            this.zInput.setSuggestion("");
        }
        this.xInput.setTextColor(0xFFFFFF);
        this.yInput.setTextColor(0xFFFFFF);
        this.zInput.setTextColor(0xFFFFFF);
        this.dimInput.setTextColor(0xFFFFFF);
    }

    public void setCoords() {
        try {
            assert (this.minecraft != null && this.minecraft.player != null);
            LocalPlayer player = this.minecraft.player;
            if (this.dimInput.getValue().equals("end")) {
                this.dimInput.setValue("the_end");
            }
            if (this.dimInput.getValue().equals("nether")) {
                this.dimInput.setValue("the_nether");
            }
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)(this.dimInput.getValue().isEmpty() ? LevelHelper.getPlayerDimensionLocation((Player)player).toString() : this.dimInput.getValue()));
            SBSetDestinationPacket packet = this.getPacket(player, resourceLocation);
            PGPackets.sendToServer(packet);
            this.onClose();
        }
        catch (Exception error) {
            this.dimInput.setSuggestion(" \u00a7c" + error.getLocalizedMessage());
        }
    }

    @NotNull
    private SBSetDestinationPacket getPacket(LocalPlayer player, ResourceLocation resourceLocation) {
        int x = Integer.parseInt(this.xInput.getValue().isEmpty() ? String.valueOf((int)player.getX()) : this.xInput.getValue());
        int y = Integer.parseInt(this.yInput.getValue().isEmpty() ? String.valueOf((int)player.getY()) : this.yInput.getValue());
        int z = Integer.parseInt(this.zInput.getValue().isEmpty() ? String.valueOf((int)player.getZ()) : this.zInput.getValue());
        ItemStack itemStack = player.getMainHandItem();
        if (!itemStack.is(PGTags.Items.PORTAL_GUNS)) {
            throw new NullPointerException("Portal gun can't be null!");
        }
        SBSetDestinationPacket packet = new SBSetDestinationPacket(new BlockPos(x, y, z), resourceLocation.toString());
        return packet;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.getFocused() instanceof Button) {
                    return super.keyPressed(pKeyCode, pScanCode, pModifiers);
                }
                this.setCoords();
                break;
            }
            case 258: {
                if (this.dimInput.isFocused()) {
                    this.dimInput.setValue(this.dS);
                }
                if (this.xInput.isFocused()) {
                    this.xInput.setValue(this.xS);
                }
                if (this.yInput.isFocused()) {
                    this.yInput.setValue(this.yS);
                }
                if (!this.zInput.isFocused()) break;
                this.zInput.setValue(this.zS);
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

