/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.gui.WaypointScreen;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.SBManageWaypointsPacket;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CreateWaypointScreen
extends AbstractBaseScreen {
    private EditBox waypointName;

    public CreateWaypointScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new"));
    }

    protected void init() {
        super.init();
        this.waypointName = new EditBox(this.font, this.width / 2 - 64, this.height / 2 - 58, 112, 12, (Component)Component.translatable((String)"chat.editBox"));
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.waypoint.new"), button -> this.createWaypoint()).pos(this.width / 2 - 136, this.height / 2 + 32).size(128, 20).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.minecraft.setScreen((Screen)new WaypointScreen())).pos(this.width / 2 + 8, this.height / 2 + 32).size(128, 20).build());
        this.waypointName.setMaxLength(128);
        this.waypointName.setBordered(true);
        this.addWidget((GuiEventListener)this.waypointName);
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new.name"), this.width / 2 - 96, this.height / 2 - 56);
            GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new.x", (Object[])new Object[]{player.getBlockX()}), this.width / 2 - 96, this.height / 2 - 36);
            GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new.y", (Object[])new Object[]{player.getBlockY()}), this.width / 2 - 96, this.height / 2 - 16);
            GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new.z", (Object[])new Object[]{player.getBlockZ()}), this.width / 2 - 96, this.height / 2);
            GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.new.dimension", (Object[])new Object[]{player.level().dimension().location().toString()}), this.width / 2 - 96, this.height / 2 + 16);
        }
        this.waypointName.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        Style style = this.minecraft.gui.getChat().getClickedComponentStyleAt((double)pMouseX, (double)pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void createWaypoint() {
        assert (this.minecraft != null && this.minecraft.player != null);
        LocalPlayer player = this.minecraft.player;
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.is(PGTags.Items.PORTAL_GUNS)) {
            BlockPos pos = player.blockPosition();
            if (this.waypointName.getValue().isEmpty()) {
                return;
            }
            SBManageWaypointsPacket packet = new SBManageWaypointsPacket(new Waypoint(pos, LevelHelper.getPlayerDimensionLocation((Player)player).toString(), this.waypointName.getValue()), false);
            PGPackets.sendToServer(packet);
            this.minecraft.setScreen((Screen)new WaypointScreen());
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257 || pKeyCode == 335) {
            this.createWaypoint();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

