/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.packet.SBSettingsPacket;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SettingsScreen
extends AbstractBaseScreen {
    private Button lockButton;
    private Button portalSize;
    private boolean lock;
    private boolean big;
    private String owner;
    private EditBox playerInput;

    public SettingsScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.settings"));
    }

    public void init() {
        super.init();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = player.getMainHandItem();
        this.lock = (Boolean)stack.getOrDefault((DataComponentType)PGDataComponents.LOCK.get(), (Object)false);
        this.owner = (String)stack.getOrDefault((DataComponentType)PGDataComponents.OWNER.get(), (Object)"");
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.settings.done"), button -> {
            SBSettingsPacket packet = new SBSettingsPacket(this.lock, this.owner);
            PGPackets.sendToServer(packet);
            this.onClose();
        }).pos(this.width / 2 - 136, this.height / 2 + 32).size(128, 20).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose()).pos(this.width / 2 + 8, this.height / 2 + 32).size(128, 20).build());
        this.lockButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)(this.lock ? "ricksportalgun.button.true" : "ricksportalgun.button.false")), button -> {
            this.lock = !this.lock;
            this.lockButton.setMessage((Component)Component.translatable((String)(this.lock ? "ricksportalgun.button.true" : "ricksportalgun.button.false")));
        }).size(64, 20).pos(this.width / 2 + 72, this.height / 2 - 74).build());
        this.playerInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 54, this.height / 2 - 50, 80, 16, (Component)Component.translatable((String)"chat.editBox")));
        this.playerInput.setBordered(true);
        this.playerInput.setMaxLength(256);
    }

    public void render(@NotNull GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        GuiHelper.drawWhiteCenteredString(pPoseStack, (Component)Component.translatable((String)"ricksportalgun.button.settings"), this.width / 2, this.height / 10);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"ricksportalgun.button.lock"), this.width / 4 - 16, this.lockButton.getY() + 4);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"ricksportalgun.button.ownership"), this.width / 4 - 16, this.playerInput.getY() + 4);
        GuiHelper.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick, new AbstractWidget[]{this.lockButton, this.playerInput});
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

