/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.gui.WaypointScreen;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.SBManageWaypointsPacket;
import com.jdolphin.ricksportalgun.common.packet.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class WaypointInfoScreen
extends AbstractBaseScreen {
    private Waypoint wp;

    protected WaypointInfoScreen(Waypoint waypoint) {
        super((Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info"));
        this.wp = waypoint;
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        GuiHelper.drawWhiteCenteredString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info"), this.width / 2, 30);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info.name", (Object[])new Object[]{this.wp.getName()}), this.width / 2 - 128, this.height / 2 - 48);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info.x", (Object[])new Object[]{this.wp.getX()}), this.width / 2 - 128, this.height / 2 - 32);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info.y", (Object[])new Object[]{this.wp.getY()}), this.width / 2 - 128, this.height / 2 - 16);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info.z", (Object[])new Object[]{this.wp.getZ()}), this.width / 2 - 128, this.height / 2);
        GuiHelper.drawWhiteString(pPoseStack, (Component)Component.translatable((String)"menu.ricksportalgun.waypoints.info.dimension", (Object[])new Object[]{this.wp.getDim()}), this.width / 2 - 128, this.height / 2 + 16);
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    protected void init() {
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.waypoint.select"), button -> {
            LocalPlayer player = this.minecraft.player;
            ItemStack itemStack = player.getMainHandItem();
            if (itemStack.is(PGTags.Items.PORTAL_GUNS)) {
                SBSetDestinationPacket packet = new SBSetDestinationPacket(this.wp.getBlockPos(), this.wp.getDim());
                PGPackets.sendToServer(packet);
                this.onClose();
            }
        }).pos(this.width / 2 - 136, this.height / 2 + 32).size(128, 20).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"ricksportalgun.button.waypoint.delete"), button -> {
            LocalPlayer player = this.minecraft.player;
            ItemStack itemStack = player.getMainHandItem();
            if (itemStack.is(PGTags.Items.PORTAL_GUNS)) {
                SBManageWaypointsPacket packet = new SBManageWaypointsPacket(this.wp, true);
                PGPackets.sendToServer(packet);
                this.minecraft.setScreen((Screen)new WaypointScreen());
                player.displayClientMessage((Component)Component.translatable((String)"notice.ricksportalgun.waypoint.deleted", (Object[])new Object[]{this.wp.getName()}).withStyle(ChatFormatting.GREEN), false);
            }
        }).size(128, 20).pos(this.width / 2 + 8, this.height / 2 + 32).build());
        super.init();
    }
}

