/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui;

import com.google.common.collect.ImmutableList;
import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.gui.CreateWaypointScreen;
import com.jdolphin.ricksportalgun.client.gui.WaypointInfoScreen;
import com.jdolphin.ricksportalgun.client.gui.widget.BetterImageButton;
import com.jdolphin.ricksportalgun.client.gui.widget.ScrollableList;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.packet.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WaypointScreen
extends AbstractBaseScreen {
    public WaypointList waypointList;
    public Button addWaypoint;
    public static ResourceLocation NEW_WAYPOINT_TEXTURES = PGHelper.createLocation("icon/new_waypoint");
    public static ResourceLocation WAYPOINT_INFO_TEXTURES = PGHelper.createLocation("icon/waypoint_info");
    protected List<Waypoint> waypointCache;

    public WaypointScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.waypoints"));
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null && this.minecraft.screen != null && this.minecraft.player != null);
        LocalPlayer player = this.minecraft.player;
        this.addWaypoint = this.addRenderableWidget(new BetterImageButton(this.width / 2 + 68, 26, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.new"), button -> this.minecraft.setScreen((Screen)new CreateWaypointScreen()), 20, 20, NEW_WAYPOINT_TEXTURES));
        ItemStack stack = player.getMainHandItem();
        if (stack.is(PGTags.Items.PORTAL_GUNS)) {
            this.waypointList = (WaypointList)this.addWidget((GuiEventListener)new WaypointList(this, this.minecraft, stack));
        }
    }

    public void tick() {
        super.tick();
        ItemStack heldItem = this.minecraft.player.getMainHandItem();
        if (heldItem.is(PGTags.Items.PORTAL_GUNS)) {
            if (!(this.waypointCache != null && this.waypointCache.equals(PortalGunItem.getWaypoints(heldItem)) || this.waypointList == null)) {
                this.waypointList.refreshEntries(heldItem);
            }
        } else {
            this.onClose();
        }
    }

    public void render(@NotNull GuiGraphics stack, int pMouseX, int pMouseY, float pPartialTick) {
        this.addWaypoint.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.waypoint.new")));
        if (this.waypointList != null) {
            this.waypointList.render(stack, pMouseX, pMouseY, pPartialTick);
        }
        GuiHelper.drawWhiteCenteredString(stack, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.saved"), this.width / 2, 30);
        assert (this.minecraft != null);
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderWithTooltip(stack, pMouseX, pMouseY, pPartialTick);
        }
        super.render(stack, pMouseX, pMouseY, pPartialTick);
    }

    public static class WaypointList
    extends ScrollableList<WaypointEntry> {
        public final ItemStack stack;
        public final PortalGunItem item;
        public final WaypointScreen screen;

        public WaypointList(WaypointScreen screen, Minecraft minecraft, ItemStack stack) {
            super(minecraft, screen.width, screen.height, 0, screen.height / 3 - 30, 21);
            this.stack = stack;
            this.screen = screen;
            this.item = (PortalGunItem)stack.getItem();
            this.refreshEntries(stack);
        }

        public void refreshEntries(ItemStack stack) {
            this.children().clear();
            List<Waypoint> waypoints = PortalGunItem.getWaypoints(stack);
            this.screen.waypointCache = waypoints;
            for (Waypoint waypoint : waypoints) {
                if (waypoint == null) {
                    LogManager.getLogger().warn("Failed to get Waypoint!");
                    continue;
                }
                this.addEntry(new WaypointEntry(waypoint, this));
            }
        }

        @Override
        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() - 32;
        }

        @Override
        public int getRowWidth() {
            return super.getRowWidth() - 32;
        }

        public void updateNarration(NarrationElementOutput output) {
            output.add(NarratedElementType.USAGE, "");
        }

        public static class WaypointEntry
        extends ScrollableList.Entry<WaypointEntry> {
            private final Waypoint waypoint;
            private final Button button;
            private final Button infoButton;
            protected WaypointList list;

            WaypointEntry(Waypoint waypoint, WaypointList list) {
                this.waypoint = waypoint;
                this.list = list;
                this.button = Button.builder((Component)Component.literal((String)waypoint.getName()), pButton -> {
                    SBSetDestinationPacket packet = new SBSetDestinationPacket(waypoint);
                    PGPackets.sendToServer(packet);
                    list.minecraft.setScreen(null);
                }).pos(16, 0).size(128, 20).build();
                this.infoButton = new BetterImageButton(0, 0, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.info"), button -> list.minecraft.setScreen((Screen)new WaypointInfoScreen(waypoint)), 20, 20, WAYPOINT_INFO_TEXTURES);
            }

            @Override
            public void render(@NotNull GuiGraphics pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                WaypointList wpList = this.list;
                if (pTop > wpList.headerHeight && pTop + wpList.itemHeight < wpList.height - wpList.itemHeight) {
                    this.infoButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"ricksportalgun.button.waypoint.info")));
                    this.button.setX(wpList.getWidth() / 2 - 64);
                    this.button.setY(pTop);
                    this.button.setMessage((Component)Component.literal((String)this.waypoint.getName()));
                    this.button.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
                    this.infoButton.setX(wpList.getWidth() / 2 + 68);
                    this.infoButton.setY(pTop);
                    this.infoButton.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
                }
            }

            @NotNull
            public List<? extends GuiEventListener> children() {
                return ImmutableList.of((Object)this.button, (Object)this.infoButton);
            }

            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                if (this.button.mouseClicked(pMouseX, pMouseY, pButton)) {
                    return true;
                }
                return this.infoButton.mouseClicked(pMouseX, pMouseY, pButton);
            }

            public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
                return this.button.mouseReleased(pMouseX, pMouseY, pButton) || this.infoButton.mouseReleased(pMouseX, pMouseY, pButton);
            }
        }
    }
}

