/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.gui.widget;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.gui.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.gui.widget.ScrollableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class SuggestionTextFieldWidget
extends EditBox {
    private final List<String> suggestions;
    private final SuggestionList suggestionListWidget;

    public SuggestionTextFieldWidget(AbstractBaseScreen screen, int x, int y, int width, int height, MutableComponent text, List<String> suggestions) {
        super(Minecraft.getInstance().font, x, y, width, height, (Component)text);
        this.suggestions = suggestions;
        this.suggestionListWidget = new SuggestionList(Minecraft.getInstance(), width, height * 3, x, y + height, 14, this);
    }

    public SuggestionList getSuggestionList() {
        return this.suggestionListWidget;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.isFocused()) {
            this.suggestionListWidget.visible = false;
        } else {
            this.suggestionListWidget.visible = true;
            this.suggestionListWidget.render(context, mouseX, mouseY, delta);
        }
        super.renderWidget(context, mouseX, mouseY, delta);
    }

    public void update() {
        List<String> suggestions = this.sortSuggestions(this.suggestions);
        this.suggestionListWidget.setSuggestions(suggestions);
        this.suggestionListWidget.setScrollAmount(0.0);
    }

    private List<String> sortSuggestions(List<String> suggestions) {
        String string = this.getValue().substring(0, this.getCursorPosition());
        int i = SuggestionTextFieldWidget.getStartOfCurrentWord(string);
        String string2 = string.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (String suggestion : suggestions) {
            String s = suggestion.substring(suggestion.indexOf(":") + 1);
            if (s.startsWith(string2)) {
                list.add(suggestion);
            }
            if (!suggestion.startsWith(string2)) {
                list2.add(suggestion);
                continue;
            }
            if (list.contains(suggestion)) continue;
            list.add(suggestion);
        }
        list.addAll(list2);
        return list;
    }

    private static int getStartOfCurrentWord(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = Pattern.compile("(\\s+)").matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    public static class SuggestionList
    extends ScrollableList<SuggestionEntry> {
        private final SuggestionTextFieldWidget widget;

        public SuggestionList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SuggestionTextFieldWidget widget) {
            super(minecraft, width, height, x, y, itemHeight);
            this.widget = widget;
            List<String> suggestions = widget.suggestions;
            this.setSuggestions(suggestions);
        }

        public void setSuggestions(List<String> suggestions) {
            this.clearEntries();
            for (String s : suggestions) {
                if (s != null && !s.isEmpty()) {
                    SuggestionEntry entry = new SuggestionEntry(s, this);
                    if (this.children().contains(entry)) continue;
                    this.addEntry(entry);
                    continue;
                }
                LogManager.getLogger().warn("Failed to get suggestion: {}", (Object)s);
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            SuggestionEntry hoveredEntry = (SuggestionEntry)this.getEntryAtPosition(mouseX, mouseY);
            if (hoveredEntry == null) {
                this.widget.setFocused(false);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.widget.isFocused()) {
                int x1 = this.getLeft();
                int y1 = this.getTop();
                int x2 = this.getRight();
                int y2 = this.getBottom();
                graphics.enableScissor(x1, y1, x2, y2);
                graphics.fill(x1, y1, x2, y2, -805306368);
                graphics.disableScissor();
                graphics.renderOutline(x1, y1, this.getWidth(), this.getHeight(), Color.WHITE.getRGB());
                super.render(graphics, mouseX, mouseY, delta);
            }
        }

        @Override
        public int getRowWidth() {
            return this.width - 6;
        }

        public void updateNarration(NarrationElementOutput output) {
            output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.selection.usage"));
        }

        public static class SuggestionEntry
        extends ScrollableList.Entry<SuggestionEntry> {
            private final String string;
            private final Button button;
            protected SuggestionList list;
            private final SuggestionTextFieldWidget widget;

            SuggestionEntry(String suggestion, SuggestionList list) {
                this.string = suggestion;
                this.list = list;
                this.widget = list.widget;
                this.button = new PGTextButton(0, 0, this.list.width - 6, list.itemHeight, (Component)Component.literal((String)suggestion), pButton -> {
                    list.widget.setValue(suggestion);
                    list.widget.setFocused(false);
                }, Minecraft.getInstance().font);
            }

            @Override
            public void render(@NotNull GuiGraphics context, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.widget.visible) {
                    SuggestionList wpList = this.list;
                    if (top > wpList.headerHeight) {
                        this.button.setX(wpList.getLeft() + 2);
                        this.button.setY(top);
                        this.button.setMessage((Component)Component.literal((String)this.string));
                        this.button.render(context, mouseX, mouseY, tickDelta);
                    }
                }
            }

            @NotNull
            public List<? extends GuiEventListener> children() {
                return ImmutableList.of((Object)this.button);
            }

            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                return this.button.mouseClicked(pMouseX, pMouseY, pButton);
            }

            public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
                return this.button.mouseReleased(pMouseX, pMouseY, pButton);
            }

            @Override
            public boolean isDragging() {
                return super.isDragging();
            }
        }
    }
}

