/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.renderer;

import com.jdolphin.ricksportalgun.client.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PortalEntityRenderer
extends EntityRenderer<PortalEntity> {
    public static final ResourceLocation PORTAL_TEXTURE = PGHelper.createLocation("textures/entity/portal.png");
    public PortalEntityModel model;

    public PortalEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.bakeLayer(PortalEntityModel.LAYER_LOCATION));
    }

    protected void scale(PortalEntity entity, PoseStack stack, float partialTicks) {
        float f;
        if (entity.tickCount < 20) {
            f = Mth.lerp((float)((float)entity.tickCount / 20.0f), (float)0.0f, (float)1.0f);
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.scale(f, f, f);
        }
        if (entity.tickCount > 160) {
            f = Mth.lerp((float)((float)entity.tickCount / 20.0f), (float)1.0f, (float)0.0f);
            f = Mth.clamp((float)f, (float)1.0f, (float)0.0f);
            f *= f;
            f *= f;
            stack.scale(f, f, f);
        }
    }

    public void render(PortalEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        this.scale(pEntity, pMatrixStack, pPartialTicks);
        pMatrixStack.mulPose(Axis.YN.rotationDegrees(pEntity.getYRot()));
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)PORTAL_TEXTURE));
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, pEntity.getColor());
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(PortalEntity portalEntity) {
        return PORTAL_TEXTURE;
    }
}

