/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class PGCommonConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Integer> randomizer_max;
    public static final ModConfigSpec.ConfigValue<Boolean> disable_locating;
    public static final ModConfigSpec.ConfigValue<Boolean> disable_waypoints;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> disabled_dimensions;

    public static List<? extends String> getBlacklistedDims() {
        return (List)disabled_dimensions.get();
    }

    public static boolean canLocate() {
        return (Boolean)disable_locating.get() == false;
    }

    public static boolean disableWaypoints() {
        return (Boolean)disable_waypoints.get();
    }

    public static int getMaxRandomizerDistance() {
        return (Integer)randomizer_max.get();
    }

    static {
        BUILDER.translation("ricksportalgun.config").push("Rick's Portal Gun mod config");
        randomizer_max = BUILDER.comment("Maximum distance for randomizer. Default = 10000").define("randomizer_max", (Object)10000);
        disable_locating = BUILDER.comment("Disable locating players").define("disable_locating", false);
        disable_waypoints = BUILDER.comment("Disable portal gun waypoints").define("disable_waypoints", false);
        disabled_dimensions = BUILDER.defineListAllowEmpty("blacklisted_dimensions", (List)Lists.newArrayList(), () -> "", o -> o instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

