/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.jdolphin.ricksportalgun.common.util.PGTeleporter;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_OPEN = "Open";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COOLDOWN = "Cooldown";
    private Optional<BlockPos> bPos;
    private boolean acid;
    private int maxLifeTime;
    private boolean exists;
    private String dim;
    private int delay = 0;
    public int lifetime = 200;

    public boolean exists() {
        return this.exists;
    }

    public PortalEntity(EntityType<? extends PortalEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void setMaxLifeTime(int lifetime) {
        this.maxLifeTime = lifetime;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setColor(int color) {
        this.entityData.set(DATA_COLOR_ID, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(DATA_COLOR_ID);
    }

    public boolean isAcid() {
        return this.acid;
    }

    public void setPos(BlockPos pos) {
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
    }

    public void setAcid(boolean acid) {
        this.acid = acid;
    }

    public static boolean colliding(Entity entity1, Entity entity2) {
        return entity1.getBoundingBox().intersects(entity2.getBoundingBox());
    }

    public void kill() {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(DamageSource damageSource, float v) {
        return false;
    }

    public void setHopLocation(ResourceLocation dimension, BlockPos pos) {
        this.dim = dimension.toString();
        this.bPos = Optional.of(pos);
    }

    public BlockPos getHopLoc() {
        return this.bPos.orElse(BlockPos.ZERO);
    }

    public String getHopDim() {
        return this.dim == null ? "minecraft:overworld" : this.dim;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.acid = tag.getBoolean("Bootleg");
        this.dim = tag.getString(TAG_DIMENSION);
        this.bPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)TAG_BPOS);
        this.setColor(tag.getInt("Color"));
        this.lifetime = tag.getInt(TAG_OPEN);
        this.delay = tag.getInt(TAG_COOLDOWN);
        this.exists = tag.getBoolean(TAG_NEW);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("Bootleg", this.acid);
        tag.putBoolean(TAG_NEW, this.exists);
        tag.putString(TAG_DIMENSION, this.getHopDim());
        tag.put(TAG_BPOS, NbtUtils.writeBlockPos((BlockPos)this.getHopLoc()));
        tag.putInt("Color", this.getColor());
        tag.putInt(TAG_OPEN, this.lifetime);
        tag.putInt(TAG_COOLDOWN, this.delay);
    }

    public static List<Entity> getEntitiesNearby(Entity entity, double range) {
        if (!entity.level().isClientSide()) {
            AABB boundingBox = entity.getBoundingBox().inflate(range);
            List entities = entity.level().getEntitiesOfClass(Entity.class, boundingBox);
            entities.remove(entity);
            entities.removeIf(e -> e instanceof PortalEntity);
            entities.removeIf(e -> e instanceof EnderDragon);
            entities.removeIf(e -> e instanceof WitherBoss);
            entities.removeIf(e -> e instanceof Warden);
            entities.removeIf(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    return player.isOnPortalCooldown() || player.isChangingDimension() || !player.canUsePortal(false);
                }
                return false;
            });
            return entities;
        }
        return null;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.exists) {
            LevelHelper.playSound(this.level(), this.blockPosition(), PGSounds.PORTAL_SHOOT, SoundSource.PLAYERS);
        }
        this.exists = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_COLOR_ID, (Object)Color.GREEN.getRGB());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.lifetime > 0) {
                --this.lifetime;
            }
            if (this.delay > 0) {
                --this.delay;
            }
            if (this.isAddedToLevel() && this.lifetime == 0) {
                this.kill();
                return;
            }
            List<Entity> entityList = PortalEntity.getEntitiesNearby(this, 0.3);
            if (entityList != null) {
                for (Entity nearby : entityList) {
                    if (!this.acid) {
                        ResourceKey<Level> key = LevelHelper.getWorldKey(ResourceLocation.parse((String)this.getHopDim()));
                        ServerLevel serverlevel = LevelHelper.getServerWorld(this.level(), key);
                        BlockPos pos = this.getHopLoc();
                        if (!PortalEntity.colliding(this, nearby) || nearby.is((Entity)this) || nearby.isOnPortalCooldown() || nearby.isPassenger() || serverlevel == null || serverlevel.isClientSide()) continue;
                        if (nearby.canUsePortal(false) && this.delay == 0) {
                            Vec3 look = Vec3.directionFromRotation((Vec2)new Vec2(45.0f, this.getYRot() + 180.0f));
                            double dx = (double)pos.getX() + look.x * 2.0;
                            double dz = (double)pos.getZ() + look.z * 2.0;
                            PGTeleporter.TELEPORTS.put(nearby.getUUID(), new PGTeleporter(nearby, serverlevel, new Vec3(dx, (double)pos.getY(), dz), nearby.getYRot() - this.getYRot()));
                            nearby.setPortalCooldown();
                            continue;
                        }
                        return;
                    }
                    nearby.kill();
                }
            }
        }
    }
}

