/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PGDataComponents {
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"ricksportalgun");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> PORTAL_POS = PGDataComponents.register("portal_pos", builder -> builder.persistent(BlockPos.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ResourceLocation>> PORTAL_DIM = PGDataComponents.register("portal_dim", typeBuilder -> typeBuilder.persistent(ResourceLocation.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> BOOTLEG = PGDataComponents.register("bootleg", typeBuilder -> typeBuilder.persistent((Codec)Codec.BOOL));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> PORTAL_COLOUR = PGDataComponents.register("portal_color", typeBuilder -> typeBuilder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> DEFAULT_COLOUR = PGDataComponents.register("default_color", typeBuilder -> typeBuilder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FUEL = PGDataComponents.register("fuel", typeBuilder -> typeBuilder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> MAX_FUEL = PGDataComponents.register("max_fuel", typeBuilder -> typeBuilder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> LOCK = PGDataComponents.register("lock", typeBuilder -> typeBuilder.persistent((Codec)Codec.BOOL));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> OWNER = PGDataComponents.register("owner", builder -> builder.persistent((Codec)Codec.STRING));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Waypoint>>> WAYPOINTS = PGDataComponents.register("waypoints", typeBuilder -> typeBuilder.persistent(Waypoint.CODEC.listOf()).networkSynchronized(Waypoint.PACKET_CODEC.apply(ByteBufCodecs.list())).cacheEncoding());

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }
}

