/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PortalGunItem
extends Item {
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_LOCK = "Lock";
    public static final String TAG_BIG = "Big";
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_DEFAULT_COLOR = "DefaultColor";
    private final int defaultColor;

    public PortalGunItem(Item.Properties properties) {
        this(properties, Color.GREEN.getRGB());
    }

    public PortalGunItem(Item.Properties properties, int defaultColor) {
        super(properties);
        this.defaultColor = defaultColor;
    }

    public static int getMaxFuel(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)PGDataComponents.MAX_FUEL.get(), (Object)16);
    }

    public static int getFuel(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)PGDataComponents.FUEL.get(), (Object)16);
    }

    public static void lowerFuel(ItemStack stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        stack.set((DataComponentType)PGDataComponents.FUEL.get(), (Object)Math.max(0, i - amount));
    }

    public static void refillFuel(ItemStack stack) {
        stack.set((DataComponentType)PGDataComponents.FUEL.get(), (Object)PortalGunItem.getMaxFuel(stack));
    }

    public static void migrateDamage(ItemStack stack) {
        int fuel = PortalGunItem.getMaxFuel(stack) - (Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0);
        stack.set((DataComponentType)PGDataComponents.FUEL.get(), (Object)fuel);
        stack.remove(DataComponents.DAMAGE);
    }

    public boolean refuel(ItemStack stack, Player player) {
        ItemStack offhand = player.getOffhandItem();
        ItemStack mainHand = player.getMainHandItem();
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && mainHand.is(PGTags.Items.PORTAL_GUNS)) {
            if (offhand.is((Item)PGItems.PORTAL_FLUID_BOTTLE.get())) {
                PortalGunItem.refillFuel(stack);
                offhand.shrink(1);
                stack.set((DataComponentType)PGDataComponents.BOOTLEG.get(), (Object)false);
                return true;
            }
            if (offhand.is((Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get())) {
                PortalGunItem.refillFuel(stack);
                stack.set((DataComponentType)PGDataComponents.BOOTLEG.get(), (Object)true);
                offhand.shrink(1);
                return true;
            }
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = PortalGunItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            PortalGunItem.migrateDamage(stack);
            this.setDefaultColor(stack, this.defaultColor);
            if ((((Boolean)stack.getOrDefault((DataComponentType)PGDataComponents.LOCK.get(), (Object)false)).booleanValue() && ((String)stack.getOrDefault((DataComponentType)PGDataComponents.OWNER.get(), (Object)"")).equals(player.getUUID().toString()) || !((Boolean)stack.getOrDefault((DataComponentType)PGDataComponents.LOCK.get(), (Object)false)).booleanValue()) && !this.refuel(stack, player) && PortalGunItem.getFuel(stack) > 0) {
                PortalEntity portal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)PGEntities.PORTAL.get()), level);
                PortalEntity exPortal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)PGEntities.PORTAL.get()), level);
                exPortal.setPos(PortalGunItem.getHopCoords(stack).getX(), PortalGunItem.getHopCoords(stack).getY(), PortalGunItem.getHopCoords(stack).getZ());
                Vec3 loc = hitResult.getLocation();
                if (hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
                    Direction dir = hitResult.getDirection();
                    BlockPos bPos = hitResult.getBlockPos();
                    if (level.getBlockState(bPos.above()).is(Blocks.AIR) && dir == Direction.UP) {
                        portal.setPos(loc.x(), loc.y(), loc.z());
                    }
                    if (level.getBlockState(bPos.below()).is(Blocks.AIR) && dir == Direction.DOWN) {
                        portal.setPos(loc.x(), loc.y() - 2.0, loc.z());
                    }
                } else {
                    portal.setPos(loc.x(), loc.y() - 1.0, loc.z());
                }
                ResourceKey<Level> key = LevelHelper.getWorldKey((ResourceLocation)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_DIM.get(), (Object)Level.OVERWORLD.location()));
                ServerLevel serverlevel = LevelHelper.getServerWorld(level, key);
                portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
                exPortal.setHopLocation(level.dimension().location(), new BlockPos((int)portal.getX(), (int)portal.getY(), (int)portal.getZ()));
                portal.getOnPos();
                exPortal.getOnPos();
                portal.setColor(this.getColor(stack));
                exPortal.setColor(this.getColor(stack));
                if (((Boolean)stack.getOrDefault((DataComponentType)PGDataComponents.BOOTLEG.get(), (Object)false)).booleanValue()) {
                    portal.setAcid(true);
                    exPortal.setAcid(true);
                }
                if (!((Boolean)stack.getOrDefault((DataComponentType)PGDataComponents.BOOTLEG.get(), (Object)false)).booleanValue()) {
                    portal.setAcid(false);
                    exPortal.setAcid(false);
                }
                if (serverlevel != null) {
                    portal.setXRot(0.0f);
                    portal.setYRot(player.getYRot());
                    exPortal.setXRot(0.0f);
                    exPortal.setYRot(player.getYRot());
                    serverlevel.addFreshEntity((Entity)exPortal);
                    level.addFreshEntity((Entity)portal);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    player.getCooldowns().addCooldown((Item)this, 60);
                    if (!player.getAbilities().instabuild) {
                        PortalGunItem.lowerFuel(stack, 1);
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"notice.ricksportalgun.destination_not_found").withStyle(ChatFormatting.RED));
                }
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private boolean isAir(Level level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"item.ricksportalgun.portal_gun.tooltip.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(pStack).getX(), PortalGunItem.getHopCoords(pStack).getY(), PortalGunItem.getHopCoords(pStack).getZ()}).withStyle(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.translatable((String)"item.ricksportalgun.portal_gun.tooltip.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(pStack).toString()}).withStyle(ChatFormatting.GRAY));
    }

    public int getBarColor(ItemStack stack) {
        return this.getColor(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public void addWaypoint(ItemStack stack, Waypoint waypoint) {
        List list = (List)stack.getOrDefault((DataComponentType)PGDataComponents.WAYPOINTS.get(), List.of());
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>(list);
        waypoints.add(waypoint);
        stack.set((DataComponentType)PGDataComponents.WAYPOINTS.get(), waypoints);
    }

    public void deleteWaypoint(ItemStack stack, Waypoint waypoint) {
        List list = (List)stack.getOrDefault((DataComponentType)PGDataComponents.WAYPOINTS.get(), List.of());
        ArrayList waypoints = new ArrayList(list);
        waypoints.remove(waypoint);
        stack.set((DataComponentType)PGDataComponents.WAYPOINTS.get(), waypoints);
    }

    public int getColor(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_COLOUR.get(), (Object)Color.GREEN.getRGB());
    }

    public void setDefaultColor(ItemStack stack, int color) {
        stack.set((DataComponentType)PGDataComponents.DEFAULT_COLOUR.get(), (Object)color);
    }

    public void setColor(ItemStack stack, int color) {
        stack.set((DataComponentType)PGDataComponents.PORTAL_COLOUR.get(), (Object)color);
    }

    public static List<Waypoint> getWaypoints(ItemStack stack) {
        return (List)stack.getOrDefault((DataComponentType)PGDataComponents.WAYPOINTS.get(), List.of());
    }

    public void setHopLocation(ItemStack stack, ResourceLocation dimension, BlockPos pos) {
        stack.set((DataComponentType)PGDataComponents.PORTAL_DIM.get(), (Object)dimension);
        stack.set((DataComponentType)PGDataComponents.PORTAL_POS.get(), (Object)pos);
    }

    public static ResourceLocation getHopDimension(ItemStack stack) {
        return (ResourceLocation)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_DIM.get(), (Object)Level.OVERWORLD.location());
    }

    public static BlockPos getHopCoords(ItemStack stack) {
        return (BlockPos)stack.getOrDefault((DataComponentType)PGDataComponents.PORTAL_POS.get(), (Object)BlockPos.ZERO);
    }
}

