/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBCoordCheckerPacket(String dim) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBCoordCheckerPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SBCoordCheckerPacket::dim, SBCoordCheckerPacket::new);
    public static final CustomPacketPayload.Type<SBCoordCheckerPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("coord_check"));

    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.server;
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"notice.ricksportalgun.randomizer_find_y.start").withStyle(ChatFormatting.YELLOW), false);
            BlockPos bPos = LevelHelper.getSafePos(LevelHelper.getRandomCoord(serverPlayer.serverLevel(), PGCommonConfig.getMaxRandomizerDistance()), serverPlayer.serverLevel());
            ResourceLocation dim = ResourceLocation.parse((String)this.dim);
            ServerLevel level = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim));
            if (level == null) {
                level = serverPlayer.serverLevel();
            }
            ItemStack stack = serverPlayer.getMainHandItem();
            PortalGunItem item = PGHelper.getPortalGun(stack);
            item.setHopLocation(stack, level.dimension().location(), bPos);
            serverPlayer.sendSystemMessage((Component)Component.translatable((String)"notice.ricksportalgun.randomizer_find_y.success").withStyle(ChatFormatting.GREEN));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

