/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBLocatePlayerPacket(String name) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBLocatePlayerPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SBLocatePlayerPacket::name, SBLocatePlayerPacket::new);
    public static final CustomPacketPayload.Type<SBLocatePlayerPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("locate"));

    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel world = serverPlayer.serverLevel();
            if (PGCommonConfig.canLocate()) {
                player.sendSystemMessage((Component)Component.translatable((String)"error.ricksportalgun.player_locating_disabled").withStyle(ChatFormatting.RED));
                return;
            }
            ServerPlayer targetPlayer = serverPlayer.server.getPlayerList().getPlayerByName(this.name);
            if (targetPlayer != null) {
                ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                PortalGunItem item = PGHelper.getPortalGun(stack);
                item.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)targetPlayer), targetPlayer.blockPosition());
                player.sendSystemMessage((Component)Component.translatable((String)"notice.ricksportalgun.destination.set").withStyle(ChatFormatting.GREEN));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"error.ricksportalgun.player_not_found", (Object[])new Object[]{this.name}).withStyle(ChatFormatting.RED));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

