/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBManageWaypointsPacket(Waypoint waypoint, boolean remove) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBManageWaypointsPacket> CODEC = StreamCodec.composite(Waypoint.PACKET_CODEC, SBManageWaypointsPacket::waypoint, (StreamCodec)ByteBufCodecs.BOOL, SBManageWaypointsPacket::remove, SBManageWaypointsPacket::new);
    public static final CustomPacketPayload.Type<SBManageWaypointsPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("manage_waypoint"));

    public void handle(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.is(PGTags.Items.PORTAL_GUNS)) {
            PortalGunItem item = (PortalGunItem)stack.getItem();
            if (this.waypoint != null) {
                if (!this.remove) {
                    item.addWaypoint(stack, this.waypoint);
                }
                if (this.remove) {
                    item.deleteWaypoint(stack, this.waypoint);
                    player.displayClientMessage((Component)Component.translatable((String)"notice.ricksportalgun.waypoint.deleted", (Object[])new Object[]{this.waypoint.getName()}).withStyle(ChatFormatting.GREEN), false);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

