/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.init.PGPackets;
import com.jdolphin.ricksportalgun.common.packet.CBOpenGuiPacket;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBOpenGuiPacket() implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBOpenGuiPacket> CODEC = StreamCodec.unit((Object)new SBOpenGuiPacket());
    public static final CustomPacketPayload.Type<SBOpenGuiPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("open_gui"));

    public boolean handle(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.server;
            Iterable levels = server.getAllLevels();
            int i = ((Collection)levels).size();
            ArrayList worldList = new ArrayList();
            levels.forEach(world -> {
                ResourceLocation worldKey = world.dimension().location();
                String s = worldKey.toString();
                if (!s.isEmpty() && !worldList.contains(s)) {
                    worldList.add(s);
                }
                boolean disableWaypoints = PGCommonConfig.disableWaypoints();
                if (i == worldList.size()) {
                    PGPackets.sendToPlayer(new CBOpenGuiPacket(worldList, disableWaypoints), serverPlayer);
                }
            });
        }
        return false;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

