/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBSetDestinationPacket(BlockPos pos, String dim) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBSetDestinationPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SBSetDestinationPacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, SBSetDestinationPacket::dim, SBSetDestinationPacket::new);
    public static final CustomPacketPayload.Type<SBSetDestinationPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("destination"));

    public SBSetDestinationPacket(Waypoint waypoint) {
        this(waypoint.getBlockPos(), waypoint.getDim());
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        PortalGunItem item = PGHelper.getPortalGun(stack);
        System.out.println(PGCommonConfig.getMaxRandomizerDistance());
        if (!PGCommonConfig.getBlacklistedDims().contains(this.dim)) {
            item.setHopLocation(stack, ResourceLocation.parse((String)this.dim), this.pos);
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"notice.ricksportalgun.dimension_disabled").withStyle(ChatFormatting.RED));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

