/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet;

import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.util.helpers.PGHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SBSettingsPacket(boolean lock, String name) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SBSettingsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SBSettingsPacket::lock, (StreamCodec)ByteBufCodecs.STRING_UTF8, SBSettingsPacket::name, SBSettingsPacket::new);
    public static final CustomPacketPayload.Type<SBSettingsPacket> ID = new CustomPacketPayload.Type(PGHelper.createLocation("settings"));

    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.server;
            ItemStack stack = serverPlayer.getMainHandItem();
            stack.set((DataComponentType)PGDataComponents.LOCK.get(), (Object)this.lock);
            if (!this.name.isEmpty()) {
                ServerPlayer newOwner = server.getPlayerList().getPlayerByName(this.name);
                if (newOwner != null) {
                    stack.set((DataComponentType)PGDataComponents.OWNER.get(), (Object)newOwner.getStringUUID());
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"error.ricksportalgun.player_not_found", (Object[])new Object[]{this.name}).withStyle(ChatFormatting.RED), false);
                }
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"notice.ricksportalgun.settings.applied").withStyle(ChatFormatting.GREEN), false);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

