/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PGTeleporter {
    public static final HashMap<UUID, PGTeleporter> TELEPORTS = new HashMap();
    public final ResourceKey<Level> originalDim;
    public final UUID uuid;
    public final ServerLevel destLevel;
    public final Vec3 pos;
    public final float rot;

    public PGTeleporter(UUID id, ResourceKey<Level> level, ServerLevel destination, Vec3 position, float rotation) {
        this.uuid = id;
        this.originalDim = level;
        this.destLevel = destination;
        this.pos = position;
        this.rot = rotation;
    }

    public PGTeleporter(Entity e, ServerLevel level, Vec3 position, float rotation) {
        this(e.getUUID(), (ResourceKey<Level>)e.level().dimension(), level, position, rotation);
    }

    public PGTeleporter(Entity e, ServerLevel level, Vec3 position) {
        this(e.getUUID(), (ResourceKey<Level>)e.level().dimension(), level, position, e.getYRot());
    }

    public boolean tick(ServerLevel level) {
        Entity e = level.getEntity(this.uuid);
        if (e == null) {
            return true;
        }
        this.destLevel.getChunkAt(new BlockPos((int)this.pos.x(), (int)this.pos.y(), (int)this.pos.z()));
        e.teleportTo(this.destLevel, this.pos.x, this.pos.y, this.pos.z, RelativeMovement.ALL, this.rot - 180.0f, e.getXRot());
        return true;
    }

    public boolean shouldRun(ServerLevel level) {
        return level.dimension().location().equals((Object)this.originalDim.location());
    }
}

