/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helpers;

import com.jdolphin.ricksportalgun.PortalGunMod;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.util.PGTeleporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;

public class LevelHelper {
    public static ResourceKey<Level> getWorldKey(ResourceLocation dimension) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension);
    }

    public static ServerLevel getServerWorld(Level level, ResourceKey<Level> dimension) {
        return level.getServer().getLevel(dimension);
    }

    public static ResourceLocation getPlayerDimensionLocation(Player player) {
        return LevelHelper.getLevelDimensionLocation(player.level());
    }

    public static ResourceLocation getLevelDimensionLocation(Level world) {
        return world.dimension().location();
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category) {
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), sound, category, 1.0f, 1.0f);
    }

    public static List<BlockEntity> getBlockEntitiesInChunks(ServerLevel level, ChunkPos pos, int radius) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                list.addAll(level.getChunk(pos.x + x, pos.z + z).getBlockEntities().values());
            }
        }
        return list;
    }

    public static BlockPos getRandomCoord(ServerLevel level, int radius) {
        WorldBorder border = level.getWorldBorder();
        RandomSource rand = level.getRandom();
        int xCoord = Mth.nextInt((RandomSource)rand, (int)((int)Math.max(border.getMinX(), (double)(-radius))), (int)((int)Math.min(border.getMaxX(), (double)radius)));
        int yCoord = Mth.nextInt((RandomSource)rand, (int)(level.getMinBuildHeight() + 1), (int)level.getMaxBuildHeight());
        int zCoord = Mth.nextInt((RandomSource)rand, (int)((int)Math.max(border.getMinZ(), (double)(-radius))), (int)((int)Math.min(border.getMaxZ(), (double)radius)));
        return new BlockPos(xCoord, yCoord, zCoord);
    }

    public static ServerLevel getRandomServerLevel(MinecraftServer server) {
        Iterable worlds = server.getAllLevels();
        ArrayList worldList = new ArrayList();
        worlds.forEach(world -> {
            if (world != null) {
                worldList.add(world);
            }
        });
        return (ServerLevel)worldList.get(PortalGunMod.RANDOM.nextInt(worldList.size()));
    }

    public static void randomTP(ServerPlayer player, int radius) {
        ServerLevel level = player.serverLevel();
        ServerLevel dest = LevelHelper.getRandomServerLevel(player.server);
        LevelHelper.teleportEntity((Entity)player, dest, LevelHelper.getSafePos(LevelHelper.getRandomCoord(dest, radius), level));
    }

    public static void teleportEntity(Entity entity, ServerLevel level, BlockPos pos) {
        PGTeleporter.TELEPORTS.put(entity.getUUID(), new PGTeleporter(entity, level, pos.getCenter()));
    }

    public static BlockPos getSafePos(BlockPos bPos, ServerLevel level) {
        BlockState blockState;
        int y;
        int direction;
        ChunkAccess chunk = level.getChunk(bPos);
        level.setChunkForced(chunk.getPos().x, chunk.getPos().z, true);
        int height = level.getHeight();
        int worldCenter = (level.getMinBuildHeight() + 2 + height) / 2;
        int n = direction = y > worldCenter ? -1 : 1;
        for (y = bPos.getY(); y >= level.getMinBuildHeight() + 2 && y <= level.getHeight(); y += direction) {
            BlockPos pos1 = new BlockPos(bPos.getX(), y, bPos.getZ());
            BlockState blockState2 = level.getBlockState(pos1);
            BlockState belowState = level.getBlockState(pos1.below());
            BlockState aboveState = level.getBlockState(pos1.above());
            if (!belowState.isAir() && !aboveState.is(PGTags.Blocks.DANGEROUS_BLOCKS) && !blockState2.isSuffocating((BlockGetter)level, pos1)) break;
        }
        if ((blockState = level.getBlockState(bPos = new BlockPos(bPos.getX(), y, bPos.getZ()))).isSuffocating((BlockGetter)level, bPos) || blockState.is(PGTags.Blocks.DANGEROUS_BLOCKS) || y <= level.getMinBuildHeight() + 2 || y >= level.getHeight()) {
            return LevelHelper.getSafePos(LevelHelper.getRandomCoord(level, 500), level);
        }
        level.setChunkForced(chunk.getPos().x, chunk.getPos().z, false);
        return bPos;
    }
}

