/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jdolphin.ricksportalgun.common.RicksPortalGunMain;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class Config {
    public boolean ALLOW_PLAYER_LOCATING = true;
    public int RANDOMIZER_MAX = 1000;
    public ArrayList<String> BLACKLISTED_DIMS;
    private static Config instance;

    public static Config getInstance() {
        if (instance == null) {
            instance = Config.fromDefaults();
        }
        return instance;
    }

    public static void load(File file) {
        instance = Config.fromFile(file);
        if (instance == null) {
            instance = Config.fromDefaults();
        }
    }

    public static void load(String file) {
        Config.load(new File(file));
    }

    private static Config fromDefaults() {
        Config config = new Config();
        config.save();
        return config;
    }

    public ArrayList<class_2960> getBlacklistedDimensions() {
        ArrayList<class_2960> idList = new ArrayList<class_2960>();
        for (String s : this.BLACKLISTED_DIMS) {
            String replace = s.replaceAll("\"", "");
            idList.add(class_2960.method_60654((String)replace));
        }
        return idList;
    }

    public void save() {
        Closeable stream;
        File configDir = FabricLoader.getInstance().getConfigDir().resolve("ricksportalgun").toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            RicksPortalGunMain.LOGGER.warn("Couldn't create config directory: " + configDir.getAbsolutePath());
        }
        File configFile = new File(configDir, "ricksportalgun-common.properties");
        Properties properties = new Properties();
        if (configFile.exists()) {
            try {
                stream = new FileInputStream(configFile);
                try {
                    properties.load((InputStream)stream);
                }
                finally {
                    ((FileInputStream)stream).close();
                }
            }
            catch (IOException e) {
                RicksPortalGunMain.LOGGER.warn("Couldn't read config file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        this.ALLOW_PLAYER_LOCATING = Config.asBoolean((String)properties.computeIfAbsent("allow_player_locating", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
        this.RANDOMIZER_MAX = Config.asInt((String)properties.computeIfAbsent("randomizer_max", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1000")), 1000);
        this.BLACKLISTED_DIMS = Config.asList((String)properties.computeIfAbsent("blacklisted_dims", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), Lists.newArrayList());
        try {
            stream = new FileOutputStream(configFile);
            try {
                properties.store((OutputStream)stream, "Rick's Portal Gun configuration file");
            }
            finally {
                ((FileOutputStream)stream).close();
            }
        }
        catch (IOException e) {
            RicksPortalGunMain.LOGGER.warn("Couldn't save config file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    private static Config fromFile(File configFile) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
            return (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Exception e) {
            RicksPortalGunMain.LOGGER.warn("Exception loading config file: " + e.getLocalizedMessage());
            return null;
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    private static TriState asTriState(String property) {
        if (property == null || property.isEmpty()) {
            return TriState.DEFAULT;
        }
        switch (property.toLowerCase(Locale.ROOT)) {
            case "true": {
                return TriState.TRUE;
            }
            case "false": {
                return TriState.FALSE;
            }
        }
        return TriState.DEFAULT;
    }

    public static ArrayList asList(String list, ArrayList<String> defValue) {
        if (list == null || list.isEmpty()) {
            return defValue;
        }
        try {
            String replace = list.replace("[", "");
            String replace1 = replace.replace("]", "");
            return new ArrayList<String>(Arrays.asList(replace1.split(",")));
        }
        catch (Exception e) {
            RicksPortalGunMain.LOGGER.warn("Exception getting blacklisted dimension list: " + e.getLocalizedMessage());
            return defValue;
        }
    }

    private static int asInt(String property, int defValue) {
        if (property == null || property.isEmpty()) {
            return defValue;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException exception) {
            RicksPortalGunMain.LOGGER.warn("Error reading config value: " + exception.getLocalizedMessage());
            return defValue;
        }
    }

    private static boolean asBoolean(String property, boolean defValue) {
        return switch (Config.asTriState(property)) {
            case TriState.TRUE -> true;
            case TriState.FALSE -> false;
            default -> defValue;
        };
    }
}

