/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun;

import com.jdolphin.portalgun.config.PortalGunCommonConfig;
import com.jdolphin.portalgun.init.PGBlocks;
import com.jdolphin.portalgun.init.PGEntities;
import com.jdolphin.portalgun.init.PGItems;
import com.jdolphin.portalgun.init.PGPackets;
import com.jdolphin.portalgun.init.PGSounds;
import com.jdolphin.portalgun.init.PGTags;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.slf4j.Logger;

@Mod(value="ricksportalgun")
public class PortalGunMod {
    public static final String MODID = "ricksportalgun";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PortalGunMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::buildContents);
        PGBlocks.BLOCKS.register(modEventBus);
        PGItems.ITEMS.register(modEventBus);
        PGEntities.ENTITIES.register(modEventBus);
        PGSounds.SOUNDS.register(modEventBus);
        PGTags.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PortalGunCommonConfig.SPEC, "portalgun-common.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PGPackets::init);
        Helper.makeBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43584_)}), Items.f_42730_, (Item)PGItems.QUANTUM_LEAP_ELIXIR.get());
        Helper.makeBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43601_)}), Items.f_42545_, (Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get());
        Helper.makeBrewingRecipe((Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get(), (Item)PGItems.QUANTUM_LEAP_ELIXIR.get(), (Item)PGItems.PORTAL_FLUID_BOTTLE.get());
        Helper.makeBrewingRecipe((Item)PGItems.QUANTUM_LEAP_ELIXIR.get(), (Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get(), (Item)PGItems.PORTAL_FLUID_BOTTLE.get());
    }

    @SubscribeEvent
    public void missingMappings(MissingMappingsEvent event) {
        String path;
        ResourceLocation regName;
        for (MissingMappingsEvent.Mapping entityMapping : event.getMappings(Registries.f_256939_, "portalgun")) {
            regName = entityMapping.getKey();
            if (regName == null) continue;
            path = regName.m_135815_();
            PGEntities.ENTITIES.getEntries().stream().filter(thing -> thing.getId().m_135815_().equals(path)).forEach(entity -> entityMapping.remap((Object)((EntityType)entity.get())));
        }
        for (MissingMappingsEvent.Mapping entityMapping : event.getMappings(Registries.f_256913_, "portalgun")) {
            regName = entityMapping.getKey();
            if (regName == null) continue;
            path = regName.m_135815_();
            PGItems.ITEMS.getEntries().stream().filter(thing -> thing.getId().m_135815_().equals(path)).forEach(item -> entityMapping.remap((Object)((Item)item.get())));
        }
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.m_245282_((ItemLike)PGItems.PORTAL_FLUID_BOTTLE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.m_246326_((ItemLike)PGItems.QUANTUM_LEAP_ELIXIR.get());
            event.m_246326_((ItemLike)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get());
        }
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256869_)) {
            event.m_246326_((ItemLike)PGItems.PORTAL_GUN.get());
            event.m_246326_((ItemLike)PGItems.PRIME_PORTAL_GUN.get());
            event.m_246326_((ItemLike)PGItems.GOLDEN_PORTAL_GUN.get());
        }
    }
}

